/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.fractal.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.util.Fractal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractalHelper {
    private static Logger logger = Logger.getLogger((String)FractalHelper.class.getName());

    public static Component getRootComponent(Component component) {
        Component parent = null;
        try {
            Component[] parents = null;
            SuperController superController = Fractal.getSuperController((Component)component);
            parents = superController.getFcSuperComponents();
            if (parents == null || parents.length == 0) {
                return component;
            }
            int cfr_ignored_0 = parents.length;
            if (parents.length == 1) {
                parent = FractalHelper.getRootComponent(parents[0]);
            }
        }
        catch (NoSuchInterfaceException e) {
            parent = component;
        }
        return parent;
    }

    public static final List<Component> getAllComponentsWithAnnotation(ContentController parentContentController, Class<? extends Annotation> annotation) {
        ArrayList<Component> components = new ArrayList<Component>();
        ContentController subContentController = null;
        Component[] componentArray = parentContentController.getFcSubComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            try {
                subContentController = Fractal.getContentController((Component)component);
                if (subContentController.getFcSubComponents().length > 0) {
                    components.addAll(FractalHelper.getAllComponentsWithAnnotation(subContentController, annotation));
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
            try {
                Object o = component.getFcInterface("/content");
                if (o != null && o.getClass().isAnnotationPresent(annotation)) {
                    components.add(component);
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
            ++n2;
        }
        return components;
    }

    public static final List<Component> getAllComponentsWithMethodAnnotation(ContentController parentContentController, Class<? extends Annotation> annotation) {
        ArrayList<Component> components = new ArrayList<Component>();
        ContentController subContentController = null;
        Component[] componentArray = parentContentController.getFcSubComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o;
            Component component = componentArray[n2];
            try {
                subContentController = Fractal.getContentController((Component)component);
                if (subContentController.getFcSubComponents().length > 0) {
                    components.addAll(FractalHelper.getAllComponentsWithMethodAnnotation(subContentController, annotation));
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
            if ((o = FractalHelper.getContent(component)) != null) {
                Method[] methods;
                Method[] methodArray = methods = o.getClass().getMethods();
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method m = methodArray[n4];
                    if (m.isAnnotationPresent(annotation)) {
                        components.add(component);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return components;
    }

    public static final List<Component> getAllComponentsWithInterface(ContentController parentContentController, Class<?> clazz) {
        ArrayList<Component> components = new ArrayList<Component>();
        ContentController subContentController = null;
        Component[] componentArray = parentContentController.getFcSubComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            try {
                subContentController = Fractal.getContentController((Component)component);
                if (subContentController.getFcSubComponents().length > 0) {
                    components.addAll(FractalHelper.getAllComponentsWithInterface(subContentController, clazz));
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
            Object o = FractalHelper.getContent(component);
            try {
                clazz.cast(o);
                components.add(component);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n2;
        }
        return components;
    }

    public static final ContentController getContentController(Component component) {
        ContentController cc = null;
        if (component != null) {
            try {
                cc = Fractal.getContentController((Component)component);
            }
            catch (NoSuchInterfaceException e) {
                logger.debug((Object)e.getMessage());
            }
        }
        return cc;
    }

    public static boolean isComposite(Component component) {
        boolean result = false;
        if (component != null) {
            try {
                ContentController controller = Fractal.getContentController((Component)component);
                result = controller.getFcSubComponents().length > 1;
            }
            catch (NoSuchInterfaceException e) {
                logger.debug((Object)e.getMessage());
            }
        }
        return result;
    }

    public static Set<Component> getAllComponents(ContentController parentContentController) {
        HashSet<Component> result = new HashSet<Component>();
        ContentController subContentController = null;
        Component[] componentArray = parentContentController.getFcSubComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            try {
                subContentController = Fractal.getContentController((Component)component);
                if (subContentController != null && subContentController.getFcSubComponents().length > 0) {
                    result.addAll(FractalHelper.getAllComponents(subContentController));
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
            if (!FractalHelper.isComposite(component)) {
                result.add(component);
            }
            ++n2;
        }
        return result;
    }

    public static final Object getContent(Component component) {
        Object result = null;
        try {
            result = component.getFcInterface("/content");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return result;
    }

    public static String getName(Component component) {
        String result = null;
        try {
            NameController nc = Fractal.getNameController((Component)component);
            result = nc.getFcName();
        }
        catch (NoSuchInterfaceException e) {
            result = "NameNotFound";
        }
        return result;
    }
}

