/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.panels.UserPathSelectionPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class UserPathInputPanel
extends IzPanel
implements ActionListener {
    private InstallerFrame _parent;
    private InstallData _idata;
    private static final long serialVersionUID = 3257566217698292531L;
    protected boolean _mustExist = false;
    protected boolean _loadedDefaultDir = false;
    protected String[] _existFiles = null;
    protected UserPathSelectionPanel _pathSelectionPanel;
    protected String _error;
    protected String _warn;
    protected String _emptyTargetMsg;
    protected String _warnMsg;
    protected String _reqMsg;
    protected String _notValidMsg;
    protected String _notWritableMsg;
    protected String _createDirMsg;
    protected String _defaultDir = null;
    protected String _thisPanel = "UserPathInputPanel";
    protected String _defaultPanelName = "TargetPanel";
    protected String _targetPanel = "UserPathPanel";
    protected String _variableName = "pathVariable";

    public UserPathInputPanel(InstallerFrame installerFrame, InstallData installData, String string, String string2) {
        super(installerFrame, installData, new IzPanelLayout());
        this._parent = installerFrame;
        this._idata = installData;
        this._targetPanel = string;
        this._variableName = string2;
        this.loadMessages();
        String string3 = this.getI18nStringForClass("extendedIntro", this._thisPanel);
        if ((string3 == null || string3.endsWith("extendedIntro") || string3.indexOf(36) > -1) && ((string3 = this.getI18nStringForClass("intro", this._thisPanel)) == null || string3.endsWith("intro"))) {
            string3 = "";
        }
        this.add(this.createMultiLineLabel(string3));
        this.add(IzPanelLayout.createParagraphGap());
        this.add((Component)this.createLabel("info", this._targetPanel, "open", 2, true), "nextLine");
        this._pathSelectionPanel = new UserPathSelectionPanel(this, installData, this._targetPanel, this._variableName);
        this.add((Component)this._pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public void createLayoutBottom() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    private void loadMessages() {
        this._error = this.parent.langpack.getString("installer.error");
        this._warn = this.parent.langpack.getString("installer.warning");
        this._reqMsg = this.getMessage("required");
        this._emptyTargetMsg = this.getMessage("empty_target");
        this._warnMsg = this.getMessage("exists_warn");
        this._notValidMsg = this.getMessage("notValid");
        this._notWritableMsg = this.getMessage("notwritable");
        this._createDirMsg = this.getMessage("createdir");
    }

    private String getMessage(String string) {
        String string2 = null;
        string2 = this.getI18nStringForClass(string, this._targetPanel);
        if (string2 == null) {
            string2 = this.getI18nStringForClass(string, this._defaultPanelName);
        }
        return string2;
    }

    public boolean isValidated() {
        String string = this._pathSelectionPanel.getPath();
        boolean bl = true;
        if (string.length() == 0) {
            if (this.isMustExist()) {
                this.emitError(this._error, this._reqMsg);
                return false;
            }
            bl = this.emitWarning(this._warn, this._emptyTargetMsg);
        }
        if (!bl) {
            return bl;
        }
        File file = new File(string).getAbsoluteFile();
        string = file.toString();
        this._pathSelectionPanel.setPath(string);
        if (this.isMustExist()) {
            if (!file.exists()) {
                this.emitError(this._error, this._reqMsg);
                return false;
            }
            if (!this.pathIsValid()) {
                this.emitError(this._error, this._notValidMsg);
                return false;
            }
        } else {
            int n;
            if (!this.isWriteable()) {
                this.emitError(this._error, this._notWritableMsg);
                return false;
            }
            bl = file.exists() ? (n = this.askQuestion(this._warn, this._warnMsg, 37, 47)) == 47 : this.emitNotificationFeedback(this._createDirMsg + "\n" + string);
        }
        return bl;
    }

    protected boolean pathIsValid() {
        if (this._existFiles == null) {
            return true;
        }
        for (String string : this._existFiles) {
            File file = new File(this._pathSelectionPanel.getPath(), string).getAbsoluteFile();
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isMustExist() {
        return this._mustExist;
    }

    public void setMustExist(boolean bl) {
        this._mustExist = bl;
    }

    public String[] getExistFiles() {
        return this._existFiles;
    }

    public void setExistFiles(String[] stringArray) {
        this._existFiles = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultDir() {
        if (!this._loadedDefaultDir) {
            BufferedReader bufferedReader = null;
            try {
                Object object;
                InputStream inputStream = null;
                if (OsVersion.IS_WINDOWS) {
                    try {
                        inputStream = this._parent.getResource(this._targetPanel + ".dir.windows");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                } else if (OsVersion.IS_OSX) {
                    try {
                        inputStream = this._parent.getResource(this._targetPanel + ".dir.mac");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                } else {
                    object = System.getProperty("os.name");
                    object = ((String)object).replace(' ', '_');
                    object = ((String)object).toLowerCase();
                    try {
                        inputStream = this._parent.getResource(this._targetPanel + ".dir.".concat((String)object));
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        // empty catch block
                    }
                    if (inputStream == null) {
                        try {
                            inputStream = this._parent.getResource(this._targetPanel + ".dir.unix");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (inputStream == null) {
                    try {
                        inputStream = this._parent.getResource(this._targetPanel + ".dir");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    String string;
                    object = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader((Reader)object);
                    while ((string = bufferedReader.readLine()) != null && "".equals(string = string.trim())) {
                    }
                    this._defaultDir = string;
                    VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
                    this._defaultDir = variableSubstitutor.substitute(this._defaultDir, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this._defaultDir = null;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this._loadedDefaultDir = true;
    }

    public boolean isWriteable() {
        File file = IoHelper.existingParent(new File(this._pathSelectionPanel.getPath()));
        if (file == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File file2 = File.createTempFile("izWrTe", ".tmp", file);
                file2.deleteOnExit();
            }
            catch (IOException iOException) {
                Debug.trace(iOException.toString());
                return false;
            }
            return true;
        }
        return file.canWrite();
    }

    public String getDefaultDir() {
        if (this._defaultDir == null && !this._loadedDefaultDir) {
            this.loadDefaultDir();
        }
        return this._defaultDir;
    }

    public void setDefaultDir(String string) {
        this._defaultDir = string;
    }

    public String getTargetPanel() {
        return this._targetPanel;
    }

    public void setTargetPanel(String string) {
        this._targetPanel = string;
    }
}

