/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.UserPathInputPanel;
import com.izforge.izpack.panels.UserPathPanelAutomationHelper;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.VariableSubstitutor;

public class UserPathPanel
extends UserPathInputPanel {
    private static final long serialVersionUID = 3256443616359429170L;
    private static String thisName = "UserPathPanel";
    private boolean skip = false;
    public static String pathVariableName = "UserPathPanelVariable";
    public static String pathPackDependsName = "UserPathPanelDependsName";
    public static String pathElementName = "UserPathPanelElement";

    public UserPathPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, thisName, installerFrame.langpack.getString(thisName + ".variableName"));
        if (this.getDefaultDir() != null) {
            installData.setVariable(pathVariableName, this.getDefaultDir());
        }
    }

    public void panelActivate() {
        Object object2;
        boolean bl = false;
        Debug.trace(thisName + " looking for activation condition");
        String string = this.idata.getVariable(pathPackDependsName);
        if (string != null && !string.equalsIgnoreCase("")) {
            Debug.trace("Checking for pack dependency of " + string);
            for (Object object2 : this.idata.selectedPacks) {
                Debug.trace("- Checking if " + ((Pack)object2).name + " equals " + string);
                if (!((Pack)object2).name.equalsIgnoreCase(string)) continue;
                bl = true;
                Debug.trace("-- Found " + string + ", panel will be shown");
                break;
            }
            this.skip = !bl;
        } else {
            Debug.trace("Not Checking for a pack dependency, panel will be shown");
            this.skip = false;
        }
        if (this.skip) {
            Debug.trace(thisName + " will not be shown");
            this.parent.skipPanel();
            return;
        }
        super.panelActivate();
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
        object2 = variableSubstitutor.substitute(this.idata.getVariable(pathVariableName), null);
        this._pathSelectionPanel.setPath((String)object2);
    }

    public boolean isValidated() {
        if (!super.isValidated()) {
            return false;
        }
        this.idata.setVariable(pathVariableName, this._pathSelectionPanel.getPath());
        return true;
    }

    public void makeXMLData(IXMLElement iXMLElement) {
        if (!this.skip) {
            new UserPathPanelAutomationHelper().makeXMLData(this.idata, iXMLElement);
        }
    }

    public String getSummaryBody() {
        if (this.skip) {
            return null;
        }
        return this.idata.getVariable(pathVariableName);
    }
}

