/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jaxws;

import javax.jws.WebService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSHelper {
    public static final Class<?> getWebServiceClass(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (cls.getAnnotation(WebService.class) != null) {
            return cls;
        }
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inf = classArray[n2];
            if (inf.getAnnotation(WebService.class) != null) {
                return inf;
            }
            ++n2;
        }
        return JAXWSHelper.getWebServiceClass(cls.getSuperclass());
    }

    public static final String getWebServiceName(Class<?> wsClass) {
        String serviceName = null;
        WebService anno = wsClass.getAnnotation(WebService.class);
        serviceName = anno.serviceName() == null || anno.serviceName().trim().length() == 0 ? wsClass.getSimpleName() : anno.serviceName();
        return serviceName;
    }

    public static boolean hasWebServiceAnnotation(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (cls.getAnnotation(WebService.class) != null) {
            return true;
        }
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inf = classArray[n2];
            if (inf.getAnnotation(WebService.class) != null) {
                return true;
            }
            ++n2;
        }
        return JAXWSHelper.hasWebServiceAnnotation(cls.getSuperclass());
    }
}

