/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.bpel;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.activation.DataHandler;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.management.deployment.AtomicDeploymentService;
import org.ow2.petals.kernel.api.server.util.SystemUtil;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.jbi.JBIFileHelper;
import org.petalslink.dsb.kernel.bpel.BPELDelegate;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.bpel.api.BPELDeployer;
import org.petalslink.dsb.ws.bpel.api.BPELDescriptor;
import org.petalslink.dsb.ws.bpel.api.LinkedResourceDescriptor;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=BPELDeployer.class)})
public class BPELDeployerImpl
implements BindingController,
LifeCycleController,
BPELDeployer {
    private static final String BPEL_DEPLOYER_FOLDER_LIBS = "dsb-bundle-bpelgenerator";
    public static final String WORK_DIR = "bpel-generator";
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="atomic-deployment", signature=AtomicDeploymentService.class)
    private AtomicDeploymentService deploymentService;
    private URLClassLoader classloader;
    private File workPath;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        System.out.println("START");
        this.log = new LoggingUtil(this.logger);
        this.workPath = new File(this.configurationService.getContainerConfiguration().getWorkDirectoryPath(), WORK_DIR);
        if (!this.workPath.exists()) {
            this.workPath.mkdirs();
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deploy(BPELDescriptor bPELDescriptor, LinkedResourceDescriptor[] linkedResourceDescriptorArray) throws DSBWebServiceException {
        boolean bl;
        Object object;
        BPELDelegate bPELDelegate;
        File file;
        block14: {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            file = null;
            try {
                try {
                    System.out.println("Let's go");
                    Thread.currentThread().setContextClassLoader(this.getBpelGeneratorClassLoader());
                    System.out.println("CLASSLOADER SET");
                    bPELDelegate = new BPELDelegate(this.classloader);
                    System.out.println("DELEGATE DONE");
                    object = this.getNewWorkingFolder();
                    File file2 = this.getOutputFolder();
                    this.storeFiles((File)object, bPELDescriptor, linkedResourceDescriptorArray);
                    file = bPELDelegate.generate((File)object, file2, "1.0", new HashMap<String, String>());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
            {
                Object var8_14 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                System.out.println("2.Generated sa = " + file);
                if (file != null) break block14;
            }
            throw new DSBWebServiceException("Unable to generate Service Assembly");
        }
        bPELDelegate = JBIFileHelper.readDescriptor(file);
        if (bPELDelegate == null) {
            throw new DSBWebServiceException("Can not get the JBI descriptor from generated SA...");
        }
        object = bPELDelegate.getServiceAssembly().getIdentification().getName();
        System.out.println("SA name : " + (String)object);
        if (object == null) {
            throw new DSBWebServiceException("Can not get the JBI service assembly name from generated SA");
        }
        try {
            bl = this.deploymentService.deploy(file.toURI().toURL());
            if (!bl) {
                this.log.warning((Object)("Failed to deploy the Service Assembly located at '" + file.toURI()));
                throw new PEtALSWebServiceException("Deployment failure");
            }
            this.log.info((Object)("Service assembly '" + (String)object + "' has been deployed"));
        }
        catch (Exception exception) {
            throw new DSBWebServiceException((Throwable)exception);
        }
        try {
            bl = this.deploymentService.start((String)object);
            if (!bl) {
                this.log.warning((Object)("Failed to start the Service Assembly '" + (String)object + "'"));
                throw new PEtALSWebServiceException("Start failure, the SA can not be started");
            }
            this.log.info((Object)("Service assembly '" + (String)object + "' has been started"));
        }
        catch (Exception exception) {
            throw new DSBWebServiceException(exception.getMessage());
        }
        if (file != null) {
            file.delete();
        }
        return true;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private void storeFiles(File file, BPELDescriptor bPELDescriptor, LinkedResourceDescriptor[] linkedResourceDescriptorArray) {
        System.out.println("Storing files into = " + file);
        File file2 = new File(file, bPELDescriptor.getFileName());
        this.storeFile(file2, bPELDescriptor.getAttachment());
        if (linkedResourceDescriptorArray != null) {
            LinkedResourceDescriptor[] linkedResourceDescriptorArray2 = linkedResourceDescriptorArray;
            int n = linkedResourceDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                LinkedResourceDescriptor linkedResourceDescriptor = linkedResourceDescriptorArray2[n2];
                File file3 = new File(file, linkedResourceDescriptor.getFileName());
                this.storeFile(file3, linkedResourceDescriptor.getWSDL());
                ++n2;
            }
        }
    }

    private void storeFile(File file, DataHandler dataHandler) {
        if (file != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                dataHandler.writeTo((OutputStream)fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
    }

    private File getOutputFolder() {
        File file = new File(this.workPath, "output");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private File getNewWorkingFolder() {
        File file = new File(this.workPath, UUID.randomUUID().toString());
        file.mkdirs();
        return file;
    }

    private synchronized URLClassLoader getBpelGeneratorClassLoader() {
        File file = new File(SystemUtil.getPetalsInstallDirectory(), "lib");
        File file2 = new File(file, BPEL_DEPLOYER_FOLDER_LIBS);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".jar");
            }
        };
        File[] fileArray = file2.listFiles(fileFilter);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (fileArray != null && fileArray.length > 0) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray2[n2];
                try {
                    arrayList.add(file3.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
                ++n2;
            }
        }
        this.classloader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), BPELDeployerImpl.class.getClassLoader());
        return this.classloader;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("atomic-deployment")) {
            if (!AtomicDeploymentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AtomicDeploymentService.class.getName());
            }
            this.deploymentService = (AtomicDeploymentService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("atomic-deployment");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("atomic-deployment")) {
            return this.deploymentService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("atomic-deployment")) {
            this.deploymentService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

