/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.ws.bpel.client;

import java.io.File;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.cxf.CXFHelper;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.bpel.api.BPELDescriptor;
import org.petalslink.dsb.ws.bpel.api.LinkedResourceDescriptor;
import org.petalslink.dsb.ws.bpel.client.BPELDeployer;

public class BPELDeployerClient
implements org.petalslink.dsb.ws.bpel.api.BPELDeployer,
BPELDeployer {
    private static Log logger = LogFactory.getLog((String)BPELDeployerClient.class.getName());
    private String baseAddress;
    private org.petalslink.dsb.ws.bpel.api.BPELDeployer clientProxy;

    public BPELDeployerClient(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    public boolean deploy(BPELDescriptor bpelDescriptor, LinkedResourceDescriptor[] resources) throws DSBWebServiceException {
        logger.debug((Object)"Calling Web service");
        return this.getClientProxy().deploy(bpelDescriptor, resources);
    }

    public boolean deploy(File bpelFile, File[] resources) throws DSBWebServiceException {
        if (bpelFile == null) {
            throw new DSBWebServiceException("BPEL file can not be null");
        }
        if (!bpelFile.exists() || !bpelFile.isFile()) {
            throw new DSBWebServiceException("BPEL file %s does not exists or is not a file", new Object[]{bpelFile.getName()});
        }
        BPELDescriptor descriptor = new BPELDescriptor();
        descriptor.setFileName(bpelFile.getName());
        descriptor.setAttachment(new DataHandler((DataSource)new FileDataSource(bpelFile)));
        ArrayList<LinkedResourceDescriptor> list = new ArrayList<LinkedResourceDescriptor>();
        if (resources != null) {
            File[] fileArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file != null && file.exists() && file.isFile()) {
                    LinkedResourceDescriptor resource = new LinkedResourceDescriptor();
                    resource.setFileName(file.getName());
                    resource.setResource(new DataHandler((DataSource)new FileDataSource(file)));
                    list.add(resource);
                }
                ++n2;
            }
        }
        return this.deploy(descriptor, list.toArray(new LinkedResourceDescriptor[list.size()]));
    }

    private synchronized org.petalslink.dsb.ws.bpel.api.BPELDeployer getClientProxy() {
        if (this.clientProxy != null) {
            return this.clientProxy;
        }
        this.clientProxy = (org.petalslink.dsb.ws.bpel.api.BPELDeployer)CXFHelper.getClient((String)this.baseAddress, org.petalslink.dsb.ws.bpel.api.BPELDeployer.class);
        return this.clientProxy;
    }
}

