/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.pubsub.service;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.XMLUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.pubsub.service.NotificationCenter;
import org.petalslink.dsb.notification.commons.PropertiesConfigurationProducer;
import org.petalslink.dsb.notification.commons.api.NotificationManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@FractalComponent
public class SubscriberBootstrapImpl
implements BindingController,
LifeCycleController {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    @LifeCycleListener(phase=Phase.START, priority=0)
    public void subscribeOnBehalf() {
        NotificationManager notificationManager = NotificationCenter.get().getManager();
        if (notificationManager == null) {
            this.log.warning((Object)"Can not find the notification manager");
            return;
        }
        NotificationProducerEngine notificationProducerEngine = notificationManager.getNotificationProducerEngine();
        if (notificationProducerEngine == null) {
            this.log.warning((Object)"Can not find the notification producer engine");
            return;
        }
        URL uRL = SubscriberBootstrapImpl.class.getClassLoader().getResource("subscribers.cfg");
        Properties properties = null;
        if (uRL != null) {
            properties = new Properties();
            try {
                properties.load(SubscriberBootstrapImpl.class.getClassLoader().getResourceAsStream("subscribers.cfg"));
            }
            catch (IOException iOException) {
                this.log.warning((Object)"Error while loading subscribers", (Throwable)iOException);
            }
        }
        if (properties != null) {
            PropertiesConfigurationProducer propertiesConfigurationProducer = new PropertiesConfigurationProducer(properties);
            List list = propertiesConfigurationProducer.getSubscribes();
            for (Subscribe subscribe : list) {
                try {
                    SubscribeResponse subscribeResponse = notificationProducerEngine.subscribe(subscribe);
                    if (!this.log.isDebugEnabled()) continue;
                    Document document = Wsnb4ServUtils.getWsnbWriter().writeSubscribeResponseAsDOM(subscribeResponse);
                    this.log.debug((Object)("KERNEL SUBSCRIBE RESPONSE = " + XMLUtil.createStringFromDOMDocument((Node)document)));
                }
                catch (Exception exception) {
                    this.log.warning((Object)"Error while subscribing", (Throwable)exception);
                }
            }
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

