/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.pubsub.service.internal;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.util.ArrayList;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.pubsub.service.internal.InternalNotificationConsumer;
import org.petalslink.dsb.kernel.pubsub.service.internal.NotificationConsumerRegistry;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.ClientException;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.MessageListener;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=Client.class)})
public class InternalClient
implements BindingController,
LifeCycleController,
Client {
    public static final String UNIQUEID = "org.petalslink.dsb.clientUUID";
    private static Client instance;
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="registry", signature=NotificationConsumerRegistry.class)
    protected NotificationConsumerRegistry registry;
    private LoggerFactory loggerFactory;

    public static Client getInstance() {
        return instance;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        instance = this;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void fireAndForget(Message message) throws ClientException {
        String string = message.getProperty(UNIQUEID);
        InternalNotificationConsumer internalNotificationConsumer = null;
        if (string != null) {
            internalNotificationConsumer = this.registry.get(string);
        }
        if (internalNotificationConsumer == null) {
            throw new ClientException("Can not find any valid consumer for the current notification...");
        }
        try {
            internalNotificationConsumer.notify(Wsnb4ServUtils.getWsnbReader().readNotify(message.getPayload()));
        }
        catch (WsnbException wsnbException) {
            throw new ClientException((Throwable)wsnbException);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Message sendReceive(Message message) throws ClientException {
        throw new ClientException("sendReceive is not implemented");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void sendAsync(Message message, MessageListener messageListener) throws ClientException {
        throw new ClientException("sendAsync is not implemented");
    }

    public String getName() {
        return "JavaInternalClient";
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("registry")) {
            if (!NotificationConsumerRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NotificationConsumerRegistry.class.getName());
            }
            this.registry = (NotificationConsumerRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("registry");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("registry")) {
            return this.registry;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("registry")) {
            this.registry = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

