/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.pubsub.service.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.pubsub.service.internal.InternalNotificationConsumer;
import org.petalslink.dsb.kernel.pubsub.service.internal.NotificationConsumerRegistry;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=NotificationConsumerRegistry.class)})
public class NotificationConsumerRegistryImpl
implements BindingController,
LifeCycleController,
NotificationConsumerRegistry {
    private Logger logger;
    private LoggingUtil log;
    private Map<String, InternalNotificationConsumer> consumers;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.consumers = new HashMap<String, InternalNotificationConsumer>();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public void add(String string, InternalNotificationConsumer internalNotificationConsumer) {
        if (internalNotificationConsumer != null && internalNotificationConsumer.getTarget() != null) {
            this.consumers.put(string, internalNotificationConsumer);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public InternalNotificationConsumer get(String string) {
        return this.consumers.get(string);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public InternalNotificationConsumer remove(String string) {
        return this.consumers.remove(string);
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

