/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.resources.service;

import javax.xml.namespace.QName;
import org.petalslink.dsb.api.ServiceEndpoint;

public class ResourceIdBuilder {
    public static String ROOT = "http://dsb.petalslink.org/endpoint/identifier";
    public static final String PATTERN = String.valueOf(ROOT) + "/%s/%s/%s/";

    private ResourceIdBuilder() {
    }

    public static final String getId(ServiceEndpoint serviceEndpoint) {
        String string = String.format(PATTERN, serviceEndpoint.getComponentLocation(), serviceEndpoint.getSubdomainLocation(), serviceEndpoint.getContainerLocation());
        QName qName = new QName(string, serviceEndpoint.getEndpointName());
        return qName.toString();
    }

    public static String getEndpointName(String string) {
        return QName.valueOf(string).getLocalPart();
    }

    public static String getComponent(String string) {
        String string2 = ResourceIdBuilder.getPath(string);
        return string2.substring(0, string2.indexOf("/"));
    }

    public static String getContainer(String string) {
        String string2 = ResourceIdBuilder.getPath(string);
        String string3 = string2.substring(string2.indexOf(47) + 1);
        String string4 = string3.substring(string3.indexOf(47) + 1);
        return string4.substring(0, string4.indexOf("/"));
    }

    public static String getDomain(String string) {
        String string2 = ResourceIdBuilder.getPath(string);
        String string3 = string2.substring(string2.indexOf(47) + 1);
        return string3.substring(0, string3.indexOf("/"));
    }

    private static String getPath(String string) {
        QName qName = QName.valueOf(string);
        if (qName.getNamespaceURI().startsWith(ROOT) && qName.getNamespaceURI().length() > ROOT.length() + 1) {
            return qName.getNamespaceURI().substring(ROOT.length() + 1);
        }
        return "";
    }
}

