/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.resources.service.utils;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import java.util.HashMap;
import java.util.Map;
import org.petalslink.dsb.kernel.resources.service.utils.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAUtil {
    private Map<Framework, XmlContext> xmlContexts = new HashMap<Framework, XmlContext>();
    private Map<Framework, ThreadLocal<XmlObjectWriter>> xmlwriters = new HashMap<Framework, ThreadLocal<XmlObjectWriter>>();
    private Map<Framework, ThreadLocal<XmlObjectReader>> xmlreaders = new HashMap<Framework, ThreadLocal<XmlObjectReader>>();
    private static SOAUtil INSTANCE = null;

    private SOAUtil() {
    }

    public static SOAUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SOAUtil();
        }
        return INSTANCE;
    }

    public ThreadLocal<XmlObjectWriter> getWriter(Framework framework) {
        ThreadFrameworkLocal<XmlObjectWriter> threadFrameworkLocal = this.xmlwriters.get(framework);
        if (threadFrameworkLocal == null) {
            threadFrameworkLocal = new ThreadFrameworkLocal<XmlObjectWriter>(framework){

                @Override
                protected XmlObjectWriter initialValue() {
                    return this.getXmlContext().createWriter();
                }
            };
            this.xmlwriters.put(framework, (ThreadLocal<XmlObjectWriter>)threadFrameworkLocal);
        }
        return threadFrameworkLocal;
    }

    public ThreadLocal<XmlObjectReader> getReader(Framework framework) {
        ThreadFrameworkLocal<XmlObjectReader> threadFrameworkLocal = this.xmlreaders.get(framework);
        if (threadFrameworkLocal == null) {
            threadFrameworkLocal = new ThreadFrameworkLocal<XmlObjectReader>(framework){

                @Override
                protected XmlObjectReader initialValue() {
                    return this.getXmlContext().createReader();
                }
            };
            this.xmlreaders.put(framework, (ThreadLocal<XmlObjectReader>)threadFrameworkLocal);
        }
        return threadFrameworkLocal;
    }

    public XmlContext getXmlContext(Framework framework) {
        XmlContext xmlContext = this.xmlContexts.get(framework);
        if (xmlContext == null) {
            xmlContext = new XmlContextFactory().newContext();
            this.xmlContexts.put(framework, xmlContext);
        }
        return xmlContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadFrameworkLocal<T>
    extends ThreadLocal<T> {
        private Framework fw = null;

        public ThreadFrameworkLocal(Framework framework) {
            this.fw = framework;
        }

        public XmlContext getXmlContext() {
            return SOAUtil.getInstance().getXmlContext(this.fw);
        }
    }
}

