/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.rest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.tools.ws.WebServiceException;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.rest.RESTServiceExposer;
import org.petalslink.dsb.kernel.rest.RESTServiceInformationBean;
import org.petalslink.dsb.kernel.rest.RESTServiceManager;
import org.petalslink.dsb.kernel.rest.RESTServiceRegistry;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RESTServiceManager.class)})
public class RESTServiceManagerImpl
implements BindingController,
LifeCycleController,
RESTServiceManager {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="restregistry", signature=RESTServiceRegistry.class)
    protected RESTServiceRegistry restServiceRegistry;
    @Requires(name="restexposer", signature=RESTServiceExposer.class)
    protected RESTServiceExposer restExposer;
    private boolean exposed;
    private HashSet<RESTServiceInformationBean> services;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.services = new HashSet();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.start();
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycleListener(phase=Phase.START)
    public void exposeAll() throws WebServiceException {
        if (!this.exposed) {
            Set<RESTServiceInformationBean> set = this.restServiceRegistry.getRESTServices();
            Set<RESTServiceInformationBean> set2 = set;
            Set<RESTServiceInformationBean> set3 = this.restExposer.expose(set2);
            if (set3 != null) {
                this.services.addAll(set3);
            }
        } else {
            throw new WebServiceException("REST Services already exposed");
        }
        this.exposed = true;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("restregistry")) {
            if (!RESTServiceRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RESTServiceRegistry.class.getName());
            }
            this.restServiceRegistry = (RESTServiceRegistry)object;
            return;
        }
        if (string.equals("restexposer")) {
            if (!RESTServiceExposer.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RESTServiceExposer.class.getName());
            }
            this.restExposer = (RESTServiceExposer)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("restregistry");
        arrayList.add("restexposer");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("restregistry")) {
            return this.restServiceRegistry;
        }
        if (string.equals("restexposer")) {
            return this.restExposer;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("restregistry")) {
            this.restServiceRegistry = null;
            return;
        }
        if (string.equals("restexposer")) {
            this.restExposer = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

