/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.wsnpoller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.petalslink.dsb.kernel.wsnpoller.Configuration;
import org.petalslink.dsb.servicepoller.api.ServicePollerInformation;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationLoader {
    public static final String CRON = "cron";
    public static final String TOPOLLENDPOINT = "pollendpoint";
    public static final String TOPOLLINTERFACE = "pollinterface";
    public static final String TOPOLLOPERATION = "polloperation";
    public static final String TOPOLLSERVICE = "pollservice";
    public static final String REPLYENDPOINT = "replyendpoint";
    public static final String REPLYINTERFACE = "replyinterface";
    public static final String REPLYOPERATION = "replyoperation";
    public static final String REPLYSERVICE = "replyservice";
    public static final String TOPIC_NAME = "topicName";
    public static final String TOPIC_URI = "topicURI";
    public static final String TOPIC_PREFIX = "topicPrefix";

    public static final List<Configuration> load(File file) {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        if (file == null || file.isDirectory()) {
            return arrayList;
        }
        File file2 = file.getParentFile();
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
            Set<String> set = ConfigurationLoader.getAllKeys(properties);
            for (String string : set) {
                Configuration configuration = ConfigurationLoader.load(properties, string);
                if (configuration == null) continue;
                Document document = ConfigurationLoader.loadInputMessage(file2, string);
                if (document != null) {
                    configuration.inputMessage = document;
                }
                arrayList.add(configuration);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static Set<String> getAllKeys(Properties properties) {
        HashSet<String> hashSet = new HashSet<String>();
        if (properties == null) {
            return hashSet;
        }
        for (Object object : properties.keySet()) {
            String string = object.toString();
            if (string.indexOf(46) <= 0 || string.indexOf(46) == string.length()) continue;
            hashSet.add(string.substring(0, string.indexOf(46)));
        }
        return hashSet;
    }

    public static final Configuration load(Properties properties, String string) {
        if (properties == null || string == null || string.length() == 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object : properties.keySet()) {
            String string2 = object.toString();
            if (!string2.startsWith(String.valueOf(string) + ".")) continue;
            hashMap.put(string2.substring(string.length() + 1), properties.getProperty(string2));
        }
        if (hashMap.size() == 0) {
            return null;
        }
        return ConfigurationLoader.load(hashMap);
    }

    public static final Document loadInputMessage(File file, String string) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(new FileInputStream(new File(file, String.valueOf(string) + ".xml")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    public static final Configuration load(Map<String, String> map) {
        QName qName;
        Configuration configuration = null;
        if (map == null) {
            return configuration;
        }
        configuration = new Configuration();
        configuration.cronExpression = map.get(CRON);
        configuration.toPoll = new ServicePollerInformation();
        configuration.toPoll.setEndpointName(map.get(TOPOLLENDPOINT));
        QName qName2 = map.get(TOPOLLINTERFACE) != null ? QName.valueOf(map.get(TOPOLLINTERFACE)) : null;
        configuration.toPoll.setInterfaceName(qName2);
        QName qName3 = map.get(TOPOLLOPERATION) != null ? QName.valueOf(map.get(TOPOLLOPERATION)) : null;
        configuration.toPoll.setOperation(qName3);
        QName qName4 = map.get(TOPOLLSERVICE) != null ? QName.valueOf(map.get(TOPOLLSERVICE)) : null;
        configuration.toPoll.setServiceName(qName4);
        String string = map.get(REPLYENDPOINT);
        qName2 = map.get(REPLYINTERFACE) != null ? QName.valueOf(map.get(REPLYINTERFACE)) : null;
        qName3 = map.get(REPLYOPERATION) != null ? QName.valueOf(map.get(REPLYOPERATION)) : null;
        QName qName5 = qName4 = map.get(REPLYSERVICE) != null ? QName.valueOf(map.get(REPLYSERVICE)) : null;
        if (qName2 != null || qName4 != null || string != null) {
            configuration.replyTo = new ServicePollerInformation();
            configuration.replyTo.setEndpointName(string);
            configuration.replyTo.setInterfaceName(qName2);
            configuration.replyTo.setOperation(qName3);
            configuration.replyTo.setServiceName(qName4);
        }
        configuration.topic = qName = new QName(map.get(TOPIC_URI), map.get(TOPIC_NAME), map.get(TOPIC_PREFIX));
        return configuration;
    }
}

