/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.wsnpoller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.deployment.AtomicDeploymentService;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationException;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.XMLUtil;
import org.petalslink.dsb.servicepoller.api.ServicePollerException;
import org.petalslink.dsb.servicepoller.api.ServicePollerInformation;
import org.petalslink.dsb.servicepoller.api.WSNPoller;
import org.petalslink.dsb.servicepoller.api.WSNPollerServiceInformation;
import org.petalslink.dsb.tools.generator.wsnpoller2jbi.Poller2Jbi;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=WSNPoller.class)})
public class ServicePollerManagerImpl
implements BindingController,
LifeCycleController,
WSNPoller {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    private Map<String, PollerInformation> cache = new HashMap<String, PollerInformation>();
    @Requires(name="atomic-deployment", signature=AtomicDeploymentService.class)
    private AtomicDeploymentService deploymentService;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.cache = new HashMap<String, PollerInformation>();
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.start();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String start(ServicePollerInformation servicePollerInformation, Document document, String string, ServicePollerInformation servicePollerInformation2, QName qName) throws ServicePollerException {
        boolean bl;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got a start request for toPoll service = " + servicePollerInformation));
            this.log.debug((Object)("Cron expression is : " + string));
            this.log.debug((Object)("ReplyTo is set to : " + servicePollerInformation2));
            this.log.debug((Object)("Topic is set to : " + qName));
        }
        if (servicePollerInformation == null) {
            throw new ServicePollerException("Service to poll can not be null");
        }
        if (qName == null) {
            throw new ServicePollerException("Topic can not be null");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("component.version", "1.0");
        Poller2Jbi poller2Jbi = new Poller2Jbi(servicePollerInformation.getEndpointName(), servicePollerInformation.getInterfaceName(), servicePollerInformation.getServiceName(), servicePollerInformation.getOperation(), document, servicePollerInformation2 != null ? servicePollerInformation2.getEndpointName() : null, servicePollerInformation2 != null ? servicePollerInformation2.getInterfaceName() : null, servicePollerInformation2 != null ? servicePollerInformation2.getServiceName() : null, servicePollerInformation2 != null ? servicePollerInformation2.getOperation() : null, string, qName, hashMap);
        File file = null;
        try {
            file = poller2Jbi.generate();
        }
        catch (JBIGenerationException jBIGenerationException) {
            this.log.warning((Object)jBIGenerationException.getMessage());
            throw new ServicePollerException((Throwable)jBIGenerationException);
        }
        Jbi jbi = this.readDescriptor(file);
        if (jbi == null) {
            throw new ServicePollerException("Can not get the JBI descriptor from generated SA...");
        }
        String string2 = jbi.getServiceAssembly().getIdentification().getName();
        if (string2 == null) {
            throw new ServicePollerException("Can not get the JBI service assembly name from generated SA");
        }
        try {
            bl = this.deploymentService.deploy(file.toURI().toURL());
            if (!bl) {
                this.log.warning((Object)("Failed to deploy the Service Assembly located at '" + file.toURI().toURL()));
                throw new ServicePollerException("Deployment failure");
            }
            this.log.info((Object)("Service assembly '" + string2 + "' has been deployed"));
        }
        catch (Exception exception) {
            throw new ServicePollerException(exception.getMessage());
        }
        try {
            bl = this.deploymentService.start(string2);
            if (!bl) {
                this.log.warning((Object)("Failed to start the Service Assembly '" + string2 + "'"));
                throw new ServicePollerException("Start failure, the SA can not be started");
            }
            this.log.info((Object)("Service assembly '" + string2 + "' has been deployed"));
        }
        catch (Exception exception) {
            throw new ServicePollerException(exception.getMessage());
        }
        PollerInformation pollerInformation = new PollerInformation();
        pollerInformation.cronExpression = string;
        pollerInformation.inputMessage = document;
        pollerInformation.replyTo = servicePollerInformation2;
        pollerInformation.toPoll = servicePollerInformation;
        pollerInformation.topic = qName;
        this.cache.put(string2, pollerInformation);
        return string2;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private Jbi readDescriptor(File file) {
        if (file == null) {
            return null;
        }
        Jbi jbi = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/jbi.xml");
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            jbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)inputStream);
        }
        catch (JBIDescriptorException jBIDescriptorException) {
            jBIDescriptorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return jbi;
    }

    public void stop(ServicePollerInformation servicePollerInformation, ServicePollerInformation servicePollerInformation2) throws ServicePollerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got a stop request for toPoll service = " + servicePollerInformation));
            this.log.debug((Object)("ReployTo is set to : " + servicePollerInformation2));
        }
        throw new ServicePollerException("This method is deprecated");
    }

    public boolean stop(String string) throws ServicePollerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got a stop request for ID = " + string));
        }
        boolean bl = false;
        try {
            bl = this.deploymentService.stop(string);
            bl = this.deploymentService.shutdown(string);
            bl = this.deploymentService.undeploy(string);
        }
        catch (PetalsException petalsException) {
            throw new ServicePollerException("Can not stop poller " + string, (Throwable)petalsException);
        }
        return bl;
    }

    public boolean pause(String string) throws ServicePollerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got a pause request for ID = " + string));
        }
        boolean bl = false;
        try {
            bl = this.deploymentService.stop(string);
        }
        catch (PetalsException petalsException) {
            throw new ServicePollerException("Can not pause poller " + string, (Throwable)petalsException);
        }
        return bl;
    }

    public boolean resume(String string) throws ServicePollerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got a resume request for ID = " + string));
        }
        boolean bl = false;
        try {
            bl = this.deploymentService.start(string);
        }
        catch (PetalsException petalsException) {
            throw new ServicePollerException("Can not resume poller " + string, (Throwable)petalsException);
        }
        return bl;
    }

    public List<WSNPollerServiceInformation> getInformation() {
        ArrayList<WSNPollerServiceInformation> arrayList = new ArrayList<WSNPollerServiceInformation>(this.cache.size());
        for (String string : this.cache.keySet()) {
            PollerInformation pollerInformation = this.cache.get(string);
            WSNPollerServiceInformation wSNPollerServiceInformation = new WSNPollerServiceInformation();
            wSNPollerServiceInformation.setCronExpression(pollerInformation.cronExpression);
            try {
                wSNPollerServiceInformation.setInputMessage(XMLUtil.createStringFromDOMDocument((Node)pollerInformation.inputMessage));
            }
            catch (Exception exception) {}
            wSNPollerServiceInformation.setReplyTo(pollerInformation.replyTo);
            if (pollerInformation.topic != null) {
                wSNPollerServiceInformation.setTopicName(pollerInformation.topic.getLocalPart());
                wSNPollerServiceInformation.setTopicPrefix(pollerInformation.topic.getPrefix());
                wSNPollerServiceInformation.setTopicURI(pollerInformation.topic.getNamespaceURI());
                wSNPollerServiceInformation.setToPoll(pollerInformation.toPoll);
            }
            wSNPollerServiceInformation.setId(string);
            arrayList.add(wSNPollerServiceInformation);
        }
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("atomic-deployment")) {
            if (!AtomicDeploymentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AtomicDeploymentService.class.getName());
            }
            this.deploymentService = (AtomicDeploymentService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("atomic-deployment");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("atomic-deployment")) {
            return this.deploymentService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("atomic-deployment")) {
            this.deploymentService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    class PollerInformation {
        ServicePollerInformation toPoll;
        Document inputMessage;
        String cronExpression;
        ServicePollerInformation replyTo;
        QName topic;

        PollerInformation() {
        }
    }
}

