/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.wsnpoller;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.wsnpoller.ServicePollerServiceAdapter;
import org.petalslink.dsb.servicepoller.api.CronExpressionValidator;
import org.petalslink.dsb.servicepoller.api.DocumentHandler;
import org.petalslink.dsb.servicepoller.api.ServicePollerException;
import org.petalslink.dsb.servicepoller.api.ServicePollerInformation;
import org.petalslink.dsb.servicepoller.api.WSNPoller;
import org.petalslink.dsb.servicepoller.api.WSNPollerService;
import org.petalslink.dsb.servicepoller.api.WSNPollerServiceInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=WSNPollerService.class)})
public class ServicePollerServiceImpl
implements BindingController,
LifeCycleController,
WSNPollerService {
    private WSNPollerService adapter;
    @Requires(name="servicepoller-manager", signature=WSNPoller.class)
    private WSNPoller manager;
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.start();
    }

    public Logger getLogger() {
        return this.logger;
    }

    private synchronized WSNPollerService getAdapter() {
        if (this.adapter == null) {
            this.adapter = new ServicePollerServiceAdapter(this.manager);
        }
        return this.adapter;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean stop(String string) throws ServicePollerException {
        return this.getAdapter().stop(string);
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public boolean pause(String string) throws ServicePollerException {
        return this.getAdapter().pause(string);
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean resume(String string) throws ServicePollerException {
        return this.getAdapter().resume(string);
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String start(ServicePollerInformation servicePollerInformation, DocumentHandler documentHandler, String string, ServicePollerInformation servicePollerInformation2, String string2, String string3, String string4) throws ServicePollerException {
        try {
            CronExpressionValidator.validateExpression((String)string);
        }
        catch (ParseException parseException) {
            throw new ServicePollerException(String.format("Invalid CronExpression %s", string), (Throwable)parseException);
        }
        return this.getAdapter().start(servicePollerInformation, documentHandler, string, servicePollerInformation2, string2, string3, string4);
    }

    public List<WSNPollerServiceInformation> getInformation() {
        return this.getAdapter().getInformation();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("servicepoller-manager")) {
            if (!WSNPoller.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + WSNPoller.class.getName());
            }
            this.manager = (WSNPoller)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("servicepoller-manager");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("servicepoller-manager")) {
            return this.manager;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("servicepoller-manager")) {
            this.manager = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

