/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.wsnpoller;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.wsnpoller.Configuration;
import org.petalslink.dsb.kernel.wsnpoller.ConfigurationLoader;
import org.petalslink.dsb.kernel.wsnpoller.ServicePollerStaticConfiguration;
import org.petalslink.dsb.servicepoller.api.ServicePollerException;
import org.petalslink.dsb.servicepoller.api.WSNPoller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ServicePollerStaticConfiguration.class)})
public class ServicePollerStaticConfigurationImpl
implements BindingController,
LifeCycleController,
ServicePollerStaticConfiguration {
    public static final String CONFIG_FOLDER = "wsnpoller";
    public static final String CONFIG_FILE = "config.cfg";
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="wsn-poller", signature=WSNPoller.class)
    private WSNPoller servicePoller;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configuration;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public List<Configuration> loadStaticConfiguration() {
        File file = this.getConfigurationPath();
        if (file == null || !file.exists() || !file.isDirectory()) {
            return null;
        }
        File file2 = new File(file, CONFIG_FILE);
        if (!file2.exists()) {
            return null;
        }
        return ConfigurationLoader.load(file2);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private File getConfigurationPath() {
        File file = null;
        File file2 = new File(this.configuration.getContainerConfiguration().getRootDirectoryPath());
        File file3 = new File(file2, "conf");
        if (!file3.exists()) {
            return file;
        }
        file = new File(file3, CONFIG_FOLDER);
        return file;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    @Override
    @LifeCycleListener(phase=Phase.START, priority=0)
    public void submitJobs() {
        List<Configuration> list = this.loadStaticConfiguration();
        for (Configuration configuration : list) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Trying to launch polling on " + configuration));
                }
                String string = this.servicePoller.start(configuration.toPoll, configuration.inputMessage, configuration.cronExpression, configuration.replyTo, configuration.topic);
                this.log.info((Object)("Polling OK with ID : " + string));
            }
            catch (ServicePollerException servicePollerException) {
                String string = "Can not start polling for " + configuration;
                if (this.log.isDebugEnabled()) {
                    this.log.warning((Object)string, (Throwable)servicePollerException);
                    continue;
                }
                this.log.warning((Object)string);
            }
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("wsn-poller")) {
            if (!WSNPoller.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + WSNPoller.class.getName());
            }
            this.servicePoller = (WSNPoller)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configuration = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("wsn-poller");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("wsn-poller")) {
            return this.servicePoller;
        }
        if (string.equals("configuration")) {
            return this.configuration;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("wsn-poller")) {
            this.servicePoller = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configuration = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

