/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Cardinality;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.api.server.PetalsStateListener;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.kernel.api.management.binder.EmbeddedServiceBinder;
import org.petalslink.dsb.kernel.api.management.component.EmbeddedComponentService;
import org.petalslink.dsb.kernel.api.management.cron.EmbeddedServiceBinderCron;
import org.petalslink.dsb.kernel.api.management.cron.ServicePoller;
import org.petalslink.dsb.kernel.api.webapp.WebAppServer;
import org.petalslink.dsb.transport.api.Server;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=PetalsStateListener.class)})
public class DSBInitializer
implements BindingController,
LifeCycleController,
PetalsStateListener {
    private LoggerFactory loggerFactory;
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="embeddedcomponentservice", signature=EmbeddedComponentService.class)
    private EmbeddedComponentService embeddedComponentService;
    @Requires(name="embeddedservicebinder", signature=EmbeddedServiceBinder.class)
    private EmbeddedServiceBinder embeddedServiceBinder;
    @Requires(name="embeddedservicebindercron", signature=EmbeddedServiceBinderCron.class)
    private EmbeddedServiceBinderCron embeddedServiceBinderCron;
    @Requires(name="servicepoller", signature=ServicePoller.class)
    private ServicePoller servicePoller;
    @Requires(contingency=Contingency.OPTIONAL, name="webappserver", signature=WebAppServer.class)
    private WebAppServer webAppServer;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.MANDATORY, name="transportserver", signature=Server.class)
    private final Map<String, Object> server = new Hashtable<String, Object>();

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void onPetalsStarted() {
        this.log.info((Object)"DSB Initializer listener");
        this.log.info((Object)"Starting the transport servers");
        for (String string : this.server.keySet()) {
            this.log.info((Object)("Starting Transport Server " + string));
            ((Server)this.server.get(string)).startServer();
        }
        this.log.info((Object)"Installing required components...");
        this.embeddedComponentService.install();
        this.log.info((Object)"Binding required services...");
        this.embeddedServiceBinder.bindAll();
        this.log.info((Object)"Starting embedded service background task");
        this.embeddedServiceBinderCron.execute();
        if (this.webAppServer != null) {
            this.log.info((Object)"Start the Web application server...");
            try {
                this.webAppServer.start();
            }
            catch (DSBException dSBException) {
                this.log.warning((Object)"Can not start the Web Application, embedded management will not be available!");
            }
        }
        this.log.info((Object)"Start polling for new endpoints...");
        this.servicePoller.startPolling();
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void onPetalsStopped(boolean bl, Exception exception) {
        if (this.webAppServer != null) {
            this.log.info((Object)"Stop the HTTP server...");
            try {
                this.webAppServer.stop();
            }
            catch (DSBException dSBException) {
                this.log.warning((Object)"Can not stop the Web Application");
            }
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("embeddedcomponentservice")) {
            if (!EmbeddedComponentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EmbeddedComponentService.class.getName());
            }
            this.embeddedComponentService = (EmbeddedComponentService)object;
            return;
        }
        if (string.equals("embeddedservicebinder")) {
            if (!EmbeddedServiceBinder.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EmbeddedServiceBinder.class.getName());
            }
            this.embeddedServiceBinder = (EmbeddedServiceBinder)object;
            return;
        }
        if (string.equals("embeddedservicebindercron")) {
            if (!EmbeddedServiceBinderCron.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EmbeddedServiceBinderCron.class.getName());
            }
            this.embeddedServiceBinderCron = (EmbeddedServiceBinderCron)object;
            return;
        }
        if (string.equals("servicepoller")) {
            if (!ServicePoller.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServicePoller.class.getName());
            }
            this.servicePoller = (ServicePoller)object;
            return;
        }
        if (string.equals("webappserver")) {
            if (!WebAppServer.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + WebAppServer.class.getName());
            }
            this.webAppServer = (WebAppServer)object;
            return;
        }
        if (string.startsWith("transportserver")) {
            if (!Server.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + Server.class.getName());
            }
            this.server.put(string, object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("embeddedcomponentservice");
        arrayList.add("embeddedservicebinder");
        arrayList.add("embeddedservicebindercron");
        arrayList.add("servicepoller");
        arrayList.add("webappserver");
        arrayList.addAll((Collection)this.server.keySet());
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("embeddedcomponentservice")) {
            return this.embeddedComponentService;
        }
        if (string.equals("embeddedservicebinder")) {
            return this.embeddedServiceBinder;
        }
        if (string.equals("embeddedservicebindercron")) {
            return this.embeddedServiceBinderCron;
        }
        if (string.equals("servicepoller")) {
            return this.servicePoller;
        }
        if (string.equals("webappserver")) {
            return this.webAppServer;
        }
        if (string.startsWith(string)) {
            return this.server.get(string);
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("embeddedcomponentservice")) {
            this.embeddedComponentService = null;
            return;
        }
        if (string.equals("embeddedservicebinder")) {
            this.embeddedServiceBinder = null;
            return;
        }
        if (string.equals("embeddedservicebindercron")) {
            this.embeddedServiceBinderCron = null;
            return;
        }
        if (string.equals("servicepoller")) {
            this.servicePoller = null;
            return;
        }
        if (string.equals("webappserver")) {
            this.webAppServer = null;
            return;
        }
        if (this.server.containsKey(string)) {
            this.server.remove(string);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

