/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.jmx.agent.Introspector;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.wrapper.remote.lib.MonologFactoryMBeanImpl;
import org.ow2.petals.communication.jndi.client.JNDIService;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminServiceMBean;
import org.ow2.petals.jbi.management.deployment.DeploymentServiceMBean;
import org.ow2.petals.jbi.management.installation.InstallationServiceMBean;
import org.ow2.petals.jbi.management.recovery.SystemRecoveryService;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistryMBean;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.kernel.admin.PetalsAdminInterface;
import org.ow2.petals.kernel.admin.PetalsAdminServiceMBean;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.api.server.PetalsServer;
import org.ow2.petals.kernel.api.server.PetalsStateListener;
import org.ow2.petals.kernel.api.server.util.SystemUtil;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.server.FractalHelper;
import org.ow2.petals.kernel.server.MBeanHelper;
import org.ow2.petals.kernel.server.PetalsStopThread;
import org.ow2.petals.service.ServiceEndpointImpl;
import org.ow2.petals.tools.ws.WebServiceException;
import org.ow2.petals.tools.ws.WebServiceManager;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.util.JNDIUtil;
import org.petalslink.dsb.kernel.api.listener.LifeCycleManager;
import org.petalslink.dsb.kernel.listener.LifeCycleListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetalsServerImpl
extends org.ow2.petals.kernel.server.PetalsServerImpl {
    private static final String LOGGER_PROPERTIES_FILE_NAME = "loggers.properties";
    private static final String[] MONOLOG_FILE_HANDLERS = new String[]{"petalsFile"};
    private final List<PetalsStateListener> petalsListeners;
    private final PetalsStopThread petalsStopThread = new PetalsStopThread((PetalsServer)this);
    private DomainConfiguration domainConfiguration;
    private ContainerConfiguration containerConfiguration;
    private Component petalsComposite;
    private ContentController petalsContentController;
    private EndpointRegistry registry;

    public PetalsServerImpl() throws PetalsException {
        this(false);
    }

    public PetalsServerImpl(boolean bl) throws PetalsException {
        this.petalsListeners = new Vector<PetalsStateListener>();
    }

    public void init() throws PetalsException {
        System.setProperty("javax.management.builder.initial", "mx4j.server.MX4JMBeanServerBuilder");
        try {
            this.initializeMonolog();
            this.initializePetalsComposite();
        }
        catch (IOException iOException) {
            throw new PetalsException("Problem while initializing Petals DSB", (Throwable)iOException);
        }
    }

    public void start() throws PetalsException {
        try {
            this.startPetalsComposite();
            this.registerPetalsServer();
            this.registerMBeans();
            this.startTools();
            this.recoverSystem();
            this.startupDone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.petalsComposite != null) {
                System.err.println("Problem while starting Petals DSB, trying to stop Petals DSB cleanly...");
                try {
                    FractalHelper.stopComponent((Component)this.petalsComposite);
                }
                catch (Throwable throwable) {
                    System.err.println("Failed to stop Petals DSB cleanly");
                }
            }
            throw new PetalsException("Failed to start Petals DSB", (Throwable)exception);
        }
        this.initListeners();
        for (PetalsStateListener petalsStateListener : this.petalsListeners) {
            petalsStateListener.onPetalsStarted();
        }
        this.launchStartActions();
        System.out.println("");
        System.out.println("### The Petals Distributed Service Bus is started at " + new Date() + " ###");
        System.out.println("");
    }

    private void launchStartActions() {
        Component component = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"LifeCycleManagerImpl");
        if (component != null) {
            try {
                LifeCycleManager lifeCycleManager = (LifeCycleManager)component.getFcInterface("service");
                lifeCycleManager.onStart();
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {}
        }
    }

    private void launchStopActions() {
        Component component = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"LifeCycleManagerImpl");
        if (component != null) {
            try {
                LifeCycleManager lifeCycleManager = (LifeCycleManager)component.getFcInterface("service");
                lifeCycleManager.onStop();
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {}
        }
    }

    @Deprecated
    private void initListeners() {
        Component component = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"LifeCycleListenerManagerImpl");
        if (component != null) {
            try {
                LifeCycleListenerManager lifeCycleListenerManager = (LifeCycleListenerManager)component.getFcInterface("service");
                if (lifeCycleListenerManager != null) {
                    Set<PetalsStateListener> set = lifeCycleListenerManager.getListeners();
                    for (PetalsStateListener petalsStateListener : set) {
                        this.addPetalsStateListener(petalsStateListener);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public void stop() throws PetalsException {
        Exception exception = null;
        try {
            this.stopPetalsComposite();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        for (PetalsStateListener petalsStateListener : this.petalsListeners) {
            if (exception == null) {
                petalsStateListener.onPetalsStopped(true, null);
                continue;
            }
            petalsStateListener.onPetalsStopped(false, exception);
        }
        this.launchStopActions();
        if (exception != null) {
            if (exception instanceof PetalsException) {
                throw (PetalsException)exception;
            }
            throw new PetalsException((Throwable)exception);
        }
    }

    public void addPetalsStateListener(PetalsStateListener petalsStateListener) {
        this.petalsListeners.add(petalsStateListener);
    }

    public boolean removePetalsStateListener(PetalsStateListener petalsStateListener) {
        return this.petalsListeners.remove(petalsStateListener);
    }

    public String getContainerConfiguration() throws PetalsException {
        if (this.containerConfiguration == null) {
            throw new PetalsException("The container configuration is not properly set");
        }
        return this.containerConfiguration.toString();
    }

    public String browseJNDI() throws PetalsException {
        if (this.containerConfiguration == null) {
            throw new PetalsException("The container configuration is not properly set");
        }
        String string = null;
        Component component = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"JNDIServiceImpl");
        try {
            JNDIService jNDIService = (JNDIService)component.getFcInterface("service");
            InitialContext initialContext = jNDIService.getInitialContext();
            if (this.domainConfiguration.getJndiConfiguration() == null) {
                string = JNDIUtil.browseJNDI((InitialContext)initialContext, null, (int)0);
            } else {
                URI uRI = this.domainConfiguration.getJndiConfiguration().getJndiProviderUrl();
                string = JNDIUtil.browseJNDI((InitialContext)initialContext, (String)uRI.getHost(), (int)uRI.getPort());
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (NamingException namingException) {
            throw new PetalsException((Throwable)namingException);
        }
        return string;
    }

    public List<ServiceEndpoint> getServiceEndpoints(boolean bl) throws PetalsException {
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        try {
            List list = this.registry.getEndpoints();
            if (list != null) {
                for (ServiceEndpoint serviceEndpoint : list) {
                    ServiceEndpointImpl serviceEndpointImpl = new ServiceEndpointImpl();
                    serviceEndpointImpl.setInterfacesName(serviceEndpoint.getInterfacesName());
                    serviceEndpointImpl.setEndpointName(serviceEndpoint.getEndpointName());
                    serviceEndpointImpl.setServiceName(serviceEndpoint.getServiceName());
                    serviceEndpointImpl.setDescription(serviceEndpoint.getDescription());
                    serviceEndpointImpl.setLocation(serviceEndpoint.getLocation());
                    arrayList.add((ServiceEndpoint)serviceEndpointImpl);
                }
            }
        }
        catch (RegistryException registryException) {
            throw new PetalsException("Can not get endpoints");
        }
        return arrayList;
    }

    private void initializePetalsComposite() throws PetalsException {
        try {
            this.petalsComposite = FractalHelper.createNewComponent((String)"Petals");
            this.petalsContentController = Fractal.getContentController((Component)this.petalsComposite);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException("Error creating PEtALS Fractal Composite", (Throwable)noSuchInterfaceException);
        }
        catch (ADLException aDLException) {
            throw new PetalsException("Error creating PEtALS Fractal Composite", (Throwable)aDLException);
        }
    }

    private void initializeMonolog() throws IOException {
        URL uRL = ((Object)((Object)this)).getClass().getResource("/loggers.properties");
        if (uRL == null) {
            throw new IOException("Failed to reach Monolog resource 'loggers.properties'");
        }
        Properties properties = new Properties();
        properties.load(uRL.openStream());
        this.configureMonologHandlers(properties);
        Monolog.getMonologFactory((Properties)properties);
    }

    private void configureMonologHandlers(Properties properties) {
        File file = new File(SystemUtil.getPetalsInstallDirectory(), "logs");
        file.mkdirs();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(date);
        String[] stringArray = MONOLOG_FILE_HANDLERS;
        int n = MONOLOG_FILE_HANDLERS.length;
        int n2 = 0;
        while (n2 < n) {
            String string2;
            String string3 = stringArray[n2];
            String string4 = properties.getProperty("handler." + string3 + ".output");
            if (string4 != null) {
                string4 = string4.replace("%d", string);
                properties.setProperty("handler." + string3 + ".output", new File(file, string4).getAbsolutePath());
            }
            if ("true".equals(string2 = properties.getProperty("handler." + string3 + ".appendMode")) || "false".equals(string2)) {
                System.setProperty(string2, string2);
            }
            ++n2;
        }
    }

    private void startPetalsComposite() throws ADLException, NoSuchInterfaceException, IllegalBindingException, IllegalContentException, IllegalLifeCycleException, PetalsException {
        BindingController bindingController;
        Component component;
        Component component2 = FractalHelper.getComponentByName((ContentController)this.petalsContentController, (String)"ConfigurationServiceImpl");
        if (!FractalHelper.startComponent((Component)component2)) {
            throw new PetalsException("Failed to start PEtALS Fractal component ConfigurationServiceImpl");
        }
        ConfigurationService configurationService = (ConfigurationService)component2.getFcInterface("service");
        this.containerConfiguration = configurationService.getContainerConfiguration();
        this.domainConfiguration = configurationService.getDomainConfiguration();
        if (!this.containerConfiguration.isActivateAutoloader()) {
            component = FractalHelper.getComponentByName((ContentController)this.petalsContentController, (String)"AutoLoaderServiceImpl");
            bindingController = Fractal.getBindingController((Component)component);
            String[] stringArray = bindingController.listFc();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                bindingController.unbindFc(string);
                ++n2;
            }
            this.petalsContentController.removeFcSubComponent(component);
        }
        if (!FractalHelper.startComponent((Component)(component = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"Communication")))) {
            throw new PetalsException("Failed to start PEtALS Fractal composite Communication");
        }
        if (!FractalHelper.startComponent((Component)this.petalsComposite)) {
            throw new PetalsException("Failed to start PEtALS Fractal components");
        }
        bindingController = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"EndpointRegistryImpl");
        if (bindingController == null) {
            throw new PetalsException("Can not find the registry component EndpointRegistryImpl");
        }
        this.registry = (EndpointRegistry)bindingController.getFcInterface("service");
    }

    private void stopPetalsComposite() throws Exception {
        LifeCycleController lifeCycleController = Fractal.getLifeCycleController((Component)this.petalsComposite);
        if ("STARTED".equals(lifeCycleController.getFcState())) {
            Transporter transporter;
            Component component3;
            List list3;
            Component component2 = FractalHelper.getComponentByName((ContentController)this.petalsContentController, (String)"Container");
            ContentController contentController = Fractal.getContentController((Component)component2);
            List list2 = FractalHelper.getComponentListByPrefix((ContentController)contentController, (String)"ServiceAssemblyLifeCycle.");
            Collections.reverse(list2);
            for (List list3 : list2) {
                FractalHelper.stopComponent((Component)list3);
            }
            list3 = FractalHelper.getComponentListByPrefix((ContentController)contentController, (String)"ComponentLifeCycle.");
            Collections.reverse(list3);
            for (Component component3 : list3) {
                FractalHelper.stopComponent((Component)component3);
            }
            if (DomainConfiguration.DomainMode.STANDALONE.equals((Object)this.domainConfiguration.getMode())) {
                component3 = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"StandaloneTransporter");
                transporter = (Transporter)component3.getFcInterface("service");
                transporter.stopTraffic();
            } else {
                component3 = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"TcpTransporter");
                transporter = (Transporter)component3.getFcInterface("service");
                transporter.stopTraffic();
                Component component4 = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"LocalTransporter");
                Transporter transporter2 = (Transporter)component4.getFcInterface("service");
                transporter2.stopTraffic();
            }
            component3 = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"RouterServiceImpl");
            transporter = (RouterService)component3.getFcInterface("service");
            transporter.stopTraffic();
            FractalHelper.stopComposite((Component)this.petalsComposite);
        }
    }

    private void registerPetalsServer() throws NoSuchInterfaceException, PetalsException {
        Component component = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"PetalsAdminServiceImpl");
        PetalsAdminInterface petalsAdminInterface = (PetalsAdminInterface)component.getFcInterface("service");
        petalsAdminInterface.setPetalsStopThread(this.petalsStopThread);
    }

    private void recoverSystem() throws ADLException, NoSuchInterfaceException, IllegalBindingException, IllegalContentException, IllegalLifeCycleException, ManagementException, PetalsException {
        Component component = FractalHelper.getComponentByName((ContentController)this.petalsContentController, (String)"JBI-Management");
        ContentController contentController = Fractal.getContentController((Component)component);
        Component component2 = FractalHelper.getComponentByName((ContentController)contentController, (String)"SystemRecoveryServiceImpl");
        SystemRecoveryService systemRecoveryService = (SystemRecoveryService)component2.getFcInterface("service");
        systemRecoveryService.recoverAllEntities();
        FractalHelper.stopComponent((Component)component2);
        BindingController bindingController = Fractal.getBindingController((Component)component2);
        String[] stringArray = bindingController.listFc();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            bindingController.unbindFc(string);
            ++n2;
        }
        contentController.removeFcSubComponent(component2);
    }

    private void startupDone() throws Exception {
        Component component = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"TopologyServiceImpl");
        if (component == null) {
            if (!DomainConfiguration.DomainMode.STANDALONE.equals((Object)this.domainConfiguration.getMode())) {
                throw new NullPointerException("The topology fractal component is null");
            }
        } else {
            TopologyService topologyService = (TopologyService)component.getFcInterface("service");
            topologyService.setContainerState(this.containerConfiguration.getName(), ContainerConfiguration.ContainerState.STARTED);
        }
    }

    private void startTools() throws NoSuchInterfaceException, PetalsException {
        Component component = FractalHelper.getRecursiveComponentByName((ContentController)this.petalsContentController, (String)"WebServiceManagerImpl");
        if (component != null) {
            WebServiceManager webServiceManager = (WebServiceManager)component.getFcInterface("service");
            try {
                webServiceManager.exposeServices();
            }
            catch (WebServiceException webServiceException) {
                throw new PetalsException("Fail to expose services : " + webServiceException.getMessage());
            }
        }
    }

    public void synchronizeRegistry() throws PetalsException {
        try {
            this.registry.synchronizeData();
        }
        catch (RegistryException registryException) {
            throw new PetalsException("Fail to synchronize registry : " + registryException.getMessage());
        }
    }

    protected void registerMBeans() throws Exception {
        ContentController contentController = Fractal.getContentController((Component)this.petalsComposite);
        Introspector.CURRENCY_TIME_LIMIT = "-1";
        MBeanServer mBeanServer = MBeanHelper.findLocalJMXServer((Component)this.petalsComposite);
        MBeanHelper.registerComponent((ContentController)contentController, (String)"AdminServiceImpl", (MBeanServer)mBeanServer, AdminServiceMBean.class, (String)"Petals:name=Admin,type=service");
        MBeanHelper.registerComponent((ContentController)contentController, (String)"DeploymentServiceImpl", (MBeanServer)mBeanServer, DeploymentServiceMBean.class, (String)"Petals:name=Deployment,type=service");
        MBeanHelper.registerComponent((ContentController)contentController, (String)"InstallationServiceImpl", (MBeanServer)mBeanServer, InstallationServiceMBean.class, (String)"Petals:name=Installation,type=service");
        MBeanHelper.registerComponent((ContentController)contentController, (String)"EndpointRegistryImpl", (MBeanServer)mBeanServer, EndpointRegistryMBean.class, (String)"Petals:name=EndpointRegistry,type=service");
        MBeanHelper.registerComponent((ContentController)contentController, (String)"PetalsAdminServiceImpl", (MBeanServer)mBeanServer, PetalsAdminServiceMBean.class, (String)"Petals:name=PetalsAdmin,type=service");
        mBeanServer.registerMBean(Introspector.createMBean((Object)new MonologFactoryMBeanImpl()), new ObjectName("Petals:name=Logger,type=service"));
    }
}

