/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.io.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ComponentContextCommunication;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.component.context.ComponentContextImpl;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.messaging.endpoint.EndpointPropertiesService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.kernel.api.service.Location;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.io.server.DSBServiceServer;
import org.petalslink.dsb.kernel.io.server.DSBServiceServerFactory;
import org.petalslink.dsb.kernel.io.server.DSBServiceServerImpl;
import org.petalslink.dsb.kernel.io.server.ServerFactoryRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=DSBServiceServerFactory.class)})
public class DSBServiceServerFactoryImpl
implements BindingController,
LifeCycleController,
DSBServiceServerFactory {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private LoggerFactory loggerFactory;
    @Requires(name="router", signature=RouterService.class)
    private RouterService router;
    private Set<DSBServiceServer> servers;
    private Set<ComponentContext> contexts;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.servers = new HashSet<DSBServiceServer>();
        this.contexts = new HashSet<ComponentContext>();
        ServerFactoryRegistry.setFactory(this);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.end();
        for (DSBServiceServer dSBServiceServer : this.servers) {
            dSBServiceServer.stop();
        }
        for (ComponentContext componentContext : this.contexts) {
            try {
                this.router.removeComponent(componentContext);
            }
            catch (RoutingException routingException) {
                routingException.printStackTrace();
            }
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public DSBServiceServer getServiceServer() {
        ComponentContextCommunication componentContextCommunication = new ComponentContextCommunication(){

            public String getWorkspaceRoot() {
                return null;
            }

            public TransactionManager getTransactionManagerService() {
                return null;
            }

            public RouterService getRouterService() {
                return DSBServiceServerFactoryImpl.this.router;
            }

            public Logger getLogger() {
                return DSBServiceServerFactoryImpl.this.logger;
            }

            public Jbi getJBIDescriptor() {
                return null;
            }

            public String getInstallationRoot() {
                return null;
            }

            public InitialContext getInitialContext() {
                return null;
            }

            public EndpointRegistry getEndpointRegistry() {
                return null;
            }

            public EndpointPropertiesService getEndpointPropertiesService() {
                return null;
            }

            public AdminService getAdminService() {
                return null;
            }

            public ServiceEndpoint getAddress() {
                return new ServiceEndpoint(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public DocumentFragment getAsReference(QName qName) {
                        return null;
                    }

                    public String getEndpointName() {
                        return null;
                    }

                    public QName[] getInterfaces() {
                        return null;
                    }

                    public QName getServiceName() {
                        return null;
                    }

                    public ServiceEndpoint.EndpointType getType() {
                        return ServiceEndpoint.EndpointType.INTERNAL;
                    }

                    public void setType(ServiceEndpoint.EndpointType endpointType) {
                    }

                    public List<QName> getInterfacesName() {
                        return null;
                    }

                    public Document getDescription() {
                        return null;
                    }

                    public Location getLocation() {
                        return new Location(DSBServiceServerFactoryImpl.access$2(1.access$0(this.this$1)).getContainerConfiguration().getSubdomainName(), DSBServiceServerFactoryImpl.access$2(1.access$0(this.this$1)).getContainerConfiguration().getName(), "dsb-kernelservice-component");
                    }

                    public String toString() {
                        return "SERVICE EP : " + this.getEndpointName() + " @ " + this.getLocation();
                    }
                };
            }

            static /* synthetic */ DSBServiceServerFactoryImpl access$0(1 var0) {
                return var0.DSBServiceServerFactoryImpl.this;
            }
        };
        FakeComponentContext fakeComponentContext = new FakeComponentContext(componentContextCommunication);
        DSBServiceServerImpl dSBServiceServerImpl = new DSBServiceServerImpl((javax.jbi.component.ComponentContext)fakeComponentContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Kernel init for service and component " + fakeComponentContext.getComponentName()));
        }
        try {
            this.router.addComponent((ComponentContext)fakeComponentContext);
            this.contexts.add((ComponentContext)fakeComponentContext);
        }
        catch (RoutingException routingException) {
            routingException.printStackTrace();
        }
        this.servers.add(dSBServiceServerImpl);
        return dSBServiceServerImpl;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("router")) {
            if (!RouterService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterService.class.getName());
            }
            this.router = (RouterService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("router");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("router")) {
            return this.router;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("router")) {
            this.router = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    static /* synthetic */ ConfigurationService access$2(DSBServiceServerFactoryImpl dSBServiceServerFactoryImpl) {
        return dSBServiceServerFactoryImpl.configurationService;
    }

    class FakeComponentContext
    extends ComponentContextImpl {
        public FakeComponentContext(ComponentContextCommunication componentContextCommunication) {
            super(componentContextCommunication);
        }

        public String getComponentName() {
            return "dsb-kernelservice-component";
        }
    }
}

