/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.listener;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.fractal.utils.FractalHelper;
import org.petalslink.dsb.kernel.api.listener.LifeCycleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=LifeCycleManager.class)})
public class LifeCycleManagerImpl
implements BindingController,
LifeCycleController,
LifeCycleManager {
    private Logger logger;
    private LoggingUtil log;
    private Component component;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void onStart() {
        try {
            SuperController superController = Fractal.getSuperController((Component)this.component);
            if (superController.getFcSuperComponents().length != 1) {
                this.log.warning((Object)"Can not find a super component to look for startup annotations in the architecture");
            } else {
                Component component = superController.getFcSuperComponents()[0];
                ContentController contentController = Fractal.getContentController((Component)component);
                List list = FractalHelper.getAllComponentsWithMethodAnnotation((ContentController)contentController, LifeCycleListener.class);
                TreeMap<Integer, Set<Bean>> treeMap = new TreeMap<Integer, Set<Bean>>(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer n, Integer n2) {
                        int n3 = 0;
                        n3 = n > n2 ? -1 : (n.intValue() == n2.intValue() ? 0 : 1);
                        return n3;
                    }
                });
                this.getBeansForPhase(list, treeMap, Phase.START);
                this.invoke(treeMap);
            }
        }
        catch (Exception exception) {
            this.log.warning((Object)exception.getMessage());
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private void invoke(Map<Integer, Set<Bean>> map) {
        for (Integer n : map.keySet()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Calling services for level : " + n));
            }
            Set<Bean> set = map.get(n);
            for (Bean bean : set) {
                try {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Invoking " + bean.m.getName() + " on " + bean.o.getClass().getName()));
                    }
                    bean.m.invoke(bean.o, new Object[0]);
                }
                catch (Exception exception) {
                    if (this.log.isDebugEnabled()) {
                        this.log.warning((Object)("Problem while calling method " + bean.m.getName()), (Throwable)exception);
                        continue;
                    }
                    this.log.warning((Object)("Problem while calling method " + bean.m.getName() + " : " + exception.getMessage()));
                }
            }
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private void getBeansForPhase(List<Component> list, Map<Integer, Set<Bean>> map, Phase phase) throws NoSuchInterfaceException {
        for (Component component : list) {
            Method[] methodArray;
            Object object = component.getFcInterface("/content");
            Method[] methodArray2 = methodArray = object.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray2[n2];
                if (method.isAnnotationPresent(LifeCycleListener.class) && method.getAnnotation(LifeCycleListener.class).phase() == phase) {
                    Bean bean = new Bean();
                    bean.m = method;
                    bean.o = object;
                    bean.priority = method.getAnnotation(LifeCycleListener.class).priority();
                    if (map.get(bean.priority) == null) {
                        map.put(new Integer(bean.priority), new HashSet());
                    }
                    map.get(bean.priority).add(bean);
                }
                ++n2;
            }
        }
    }

    public void onStop() {
        try {
            SuperController superController = Fractal.getSuperController((Component)this.component);
            if (superController.getFcSuperComponents().length != 1) {
                this.log.warning((Object)"Can not find a super component to look for shutdown annotations in the architecture");
            } else {
                Component component = superController.getFcSuperComponents()[0];
                ContentController contentController = Fractal.getContentController((Component)component);
                List list = FractalHelper.getAllComponentsWithMethodAnnotation((ContentController)contentController, LifeCycleListener.class);
                TreeMap<Integer, Set<Bean>> treeMap = new TreeMap<Integer, Set<Bean>>(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer n, Integer n2) {
                        int n3 = 0;
                        n3 = n < n2 ? -1 : (n.intValue() == n2.intValue() ? 0 : 1);
                        return n3;
                    }
                });
                this.getBeansForPhase(list, treeMap, Phase.STOP);
                this.invoke(treeMap);
            }
        }
        catch (Exception exception) {
            this.log.warning((Object)exception.getMessage());
        }
    }

    public void preStart() {
        this.log.warning((Object)"Not implemented");
    }

    public void preStop() {
        this.log.warning((Object)"Not implemented");
    }

    public void preShutdown() {
        this.log.warning((Object)"Not implemented");
    }

    public void onShutdown() {
        this.log.warning((Object)"Not implemented");
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    class Bean {
        Method m;
        int priority;
        Object o;

        Bean() {
        }
    }
}

