/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.binder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.ws.api.JBIArtefactsService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.to.Component;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;
import org.petalslink.dsb.kernel.api.management.binder.BinderChecker;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=BinderChecker.class)})
public class BinderCheckerImpl
implements BindingController,
LifeCycleController,
BinderChecker {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    @Requires(name="jbiartefacts", signature=JBIArtefactsService.class)
    private JBIArtefactsService jbiArtefactsService;
    @Requires(name="dsbconfiguration", signature=DSBConfigurationService.class)
    private DSBConfigurationService dsbConfigurationService;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean canBindOnProtocol(String string) {
        boolean bl = false;
        bl = this.dsbConfigurationService.getProtocolToComponentMapping().get(string) == null ? false : this.isComponentReady((String)this.dsbConfigurationService.getProtocolToComponentMapping().get(string));
        return bl;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public boolean canExposeOnProtocol(String string) {
        boolean bl = false;
        bl = this.dsbConfigurationService.getProtocolToComponentMapping().get(string) == null ? false : this.isComponentReady((String)this.dsbConfigurationService.getProtocolToComponentMapping().get(string));
        return bl;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected boolean isComponentReady(String string) {
        boolean bl = false;
        try {
            List list = this.jbiArtefactsService.getComponents();
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !bl) {
                Component component = (Component)iterator.next();
                boolean bl2 = bl = component.getName().equals(string) && component.getState().equals("Started");
            }
        }
        catch (PEtALSWebServiceException pEtALSWebServiceException) {}
        return bl;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("jbiartefacts")) {
            if (!JBIArtefactsService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + JBIArtefactsService.class.getName());
            }
            this.jbiArtefactsService = (JBIArtefactsService)object;
            return;
        }
        if (string.equals("dsbconfiguration")) {
            if (!DSBConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBConfigurationService.class.getName());
            }
            this.dsbConfigurationService = (DSBConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("jbiartefacts");
        arrayList.add("dsbconfiguration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("jbiartefacts")) {
            return this.jbiArtefactsService;
        }
        if (string.equals("dsbconfiguration")) {
            return this.dsbConfigurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("jbiartefacts")) {
            this.jbiArtefactsService = null;
            return;
        }
        if (string.equals("dsbconfiguration")) {
            this.dsbConfigurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

