/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.binder;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.Services;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.deployment.AtomicDeploymentService;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationException;
import org.ow2.petals.tools.generator.jbi.ws2jbi.Constants;
import org.ow2.petals.tools.generator.jbi.ws2jbi.WS2Jbi;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.jbi.JBIFileHelper;
import org.petalslink.dsb.kernel.api.management.binder.BinderChecker;
import org.petalslink.dsb.kernel.api.management.binder.BinderException;
import org.petalslink.dsb.kernel.api.management.binder.ServiceBinder;
import org.petalslink.dsb.kernel.api.management.binder.ServiceRegistry;
import org.petalslink.dsb.ws.api.ServiceEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ServiceBinder.class)})
public class SOAPServiceBinderImpl
implements BindingController,
LifeCycleController,
ServiceBinder {
    private LoggerFactory loggerFactory;
    public static final String WSDL_PROPERTY = "wsdl";
    public static final String WORK_DIR = "servicebinder";
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="atomic-deployment", signature=AtomicDeploymentService.class)
    private AtomicDeploymentService deploymentService;
    @Requires(name="service-registry", signature=ServiceRegistry.class)
    private ServiceRegistry serviceRegistry;
    @Requires(name="binder-checker", signature=BinderChecker.class)
    private BinderChecker binderChecker;
    @Requires(name="admin", signature=AdminService.class)
    protected AdminService adminService;
    private File workPath;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.workPath = new File(this.configurationService.getContainerConfiguration().getWorkDirectoryPath(), WORK_DIR);
        if (!this.workPath.exists()) {
            this.workPath.mkdirs();
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public List<ServiceEndpoint> bind(Map<String, Object> map) throws BinderException {
        String string;
        File file;
        String string2;
        ArrayList<ServiceEndpoint> arrayList;
        block23: {
            boolean bl;
            block22: {
                URI uRI;
                arrayList = null;
                if (!this.binderChecker.canBindOnProtocol(this.getProtocol())) {
                    throw new BinderException("No component found to bind SOAP service");
                }
                Object object = map.get(WSDL_PROPERTY);
                if (object == null) {
                    throw new BinderException("WSDL can not be null");
                }
                string2 = (String)object;
                file = null;
                try {
                    uRI = new URI(string2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new BinderException("Bad URI " + uRISyntaxException.getMessage());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(Constants.OUTPUT_DIR, this.workPath.getAbsolutePath());
                hashMap.put("component.version", "4.0");
                WS2Jbi wS2Jbi = new WS2Jbi(uRI, hashMap);
                try {
                    file = wS2Jbi.generate();
                }
                catch (JBIGenerationException jBIGenerationException) {
                    throw new BinderException(jBIGenerationException.getMessage());
                }
                Jbi jbi = JBIFileHelper.readDescriptor((File)file);
                if (jbi == null) {
                    throw new BinderException("Can not get the JBI descriptor from generated SA...");
                }
                string = jbi.getServiceAssembly().getIdentification().getName();
                if (string == null) {
                    throw new BinderException("Can not get the JBI service assembly name from generated SA");
                }
                try {
                    bl = this.deploymentService.deploy(file.toURL());
                    if (bl) {
                        this.log.info((Object)("Service assembly '" + string + "' has been deployed"));
                        break block22;
                    }
                    this.log.warning((Object)("Failed to deploy the Service Assembly located at '" + file.toURL()));
                    throw new PEtALSWebServiceException("Deployment failure");
                }
                catch (Exception exception) {
                    throw new BinderException((Throwable)exception);
                }
            }
            try {
                bl = this.deploymentService.start(string);
                if (bl) {
                    this.log.info((Object)("Service assembly '" + string + "' has been started"));
                    break block23;
                }
                this.log.warning((Object)("Failed to start the Service Assembly '" + string + "'"));
                throw new PEtALSWebServiceException("Start failure, the SA can not be started");
            }
            catch (Exception exception) {
                throw new BinderException(exception.getMessage());
            }
        }
        this.serviceRegistry.addService("soap", string2, null);
        if (file != null) {
            file.delete();
        }
        arrayList = new ArrayList<ServiceEndpoint>();
        try {
            ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
            List list = serviceAssemblyLifeCycle.getServiceUnitLifeCycles();
            for (ServiceUnitLifeCycle serviceUnitLifeCycle : list) {
                Jbi jbi = serviceUnitLifeCycle.getServiceUnitDescriptor();
                if (jbi != null) {
                    Services services = jbi.getServices();
                    if (services != null) {
                        List list2 = services.getProvides();
                        if (list2 != null) {
                            for (org.ow2.petals.jbi.descriptor.original.generated.Provides provides : list2) {
                                ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
                                serviceEndpoint.setEndpoint(provides.getEndpointName());
                                serviceEndpoint.setItf(provides.getInterfaceName());
                                serviceEndpoint.setService(provides.getServiceName());
                                arrayList.add(serviceEndpoint);
                            }
                            continue;
                        }
                        this.log.debug((Object)"Can not find any provides");
                        continue;
                    }
                    this.log.debug((Object)"Can not find any service");
                    continue;
                }
                this.log.debug((Object)"Can not find any JBI descriptor");
            }
        }
        catch (Exception exception) {
            this.log.warning((Object)"Can not retrieve information...", (Throwable)exception);
        }
        return arrayList;
    }

    public String getProtocol() {
        return "soap";
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("atomic-deployment")) {
            if (!AtomicDeploymentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AtomicDeploymentService.class.getName());
            }
            this.deploymentService = (AtomicDeploymentService)object;
            return;
        }
        if (string.equals("service-registry")) {
            if (!ServiceRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServiceRegistry.class.getName());
            }
            this.serviceRegistry = (ServiceRegistry)object;
            return;
        }
        if (string.equals("binder-checker")) {
            if (!BinderChecker.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + BinderChecker.class.getName());
            }
            this.binderChecker = (BinderChecker)object;
            return;
        }
        if (string.equals("admin")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("atomic-deployment");
        arrayList.add("service-registry");
        arrayList.add("binder-checker");
        arrayList.add("admin");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("atomic-deployment")) {
            return this.deploymentService;
        }
        if (string.equals("service-registry")) {
            return this.serviceRegistry;
        }
        if (string.equals("binder-checker")) {
            return this.binderChecker;
        }
        if (string.equals("admin")) {
            return this.adminService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("atomic-deployment")) {
            this.deploymentService = null;
            return;
        }
        if (string.equals("service-registry")) {
            this.serviceRegistry = null;
            return;
        }
        if (string.equals("binder-checker")) {
            this.binderChecker = null;
            return;
        }
        if (string.equals("admin")) {
            this.adminService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

