/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.jndi.client.JNDIService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.api.management.component.ComponentInformationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ComponentInformationService.class)})
public class JNDIComponentInformationServiceImpl
implements BindingController,
LifeCycleController,
ComponentInformationService {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="jndi", signature=JNDIService.class)
    private JNDIService jndiService;
    private LoggerFactory loggerFactory;
    private static final Set<String> EMPTYSET = new HashSet<String>(0);

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Set<String> getConsumedServiceURLs(String string) {
        Set<String> set = null;
        Context context = this.getContext("/components/" + string + "/services/");
        if (context == null) {
            this.log.warning((Object)("Nothing found for services in component context " + string));
            return EMPTYSET;
        }
        Object object = null;
        try {
            object = context.lookup("consume");
        }
        catch (NamingException namingException) {
            this.log.warning((Object)namingException.getMessage());
        }
        if (object == null) {
            this.log.debug((Object)"Null object under consume path");
            set = EMPTYSET;
        } else if (object instanceof Set) {
            set = (Set<String>)object;
        } else {
            this.log.debug((Object)"No Set<?> object under consume path");
            set = EMPTYSET;
        }
        return set;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Set<String> getExposedServiceURLs(String string) {
        Set<String> set = null;
        Context context = this.getContext("/components/" + string + "/services/");
        if (context == null) {
            this.log.warning((Object)("Nothing found for services in component context " + string));
            return EMPTYSET;
        }
        Object object = null;
        try {
            object = context.lookup("expose");
        }
        catch (NamingException namingException) {
            this.log.warning((Object)namingException.getMessage());
        }
        if (object == null) {
            this.log.debug((Object)"Null object under expose path");
            set = EMPTYSET;
        } else if (object instanceof Set) {
            set = (Set<String>)object;
        } else {
            this.log.debug((Object)"No Set<?> object under expose path");
            set = EMPTYSET;
        }
        return set;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String getProperty(String string, String string2) {
        String string3 = null;
        Context context = this.getContext("/components/" + string + "/properties/");
        if (context == null) {
            this.log.warning((Object)("Nothing found for properties in component context " + string));
            return null;
        }
        Object object = null;
        try {
            object = context.lookup(string2);
        }
        catch (NamingException namingException) {
            this.log.warning((Object)namingException.getMessage());
        }
        if (object == null) {
            this.log.debug((Object)("Null object under property '" + string2 + "' path"));
            string3 = null;
        } else if (object instanceof String) {
            string3 = (String)object;
        } else {
            this.log.debug((Object)"No String object under property path");
            string3 = null;
        }
        return string3;
    }

    private Context getContext(String string) {
        Context context = null;
        String string2 = string;
        if (string2 != null && string2.length() >= 1 && string2.indexOf(47) == 0) {
            string2 = string2.substring(1, string2.length());
        }
        if (string2.lastIndexOf(47) == string2.length()) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String[] stringArray = string2.split("/");
        Context context2 = null;
        try {
            context2 = this.jndiService.getUsersContext();
        }
        catch (NamingException namingException) {
            this.log.warning((Object)"Can not find the users context");
            return null;
        }
        boolean bl = false;
        int n = 0;
        while (!bl && n < stringArray.length) {
            Object object = null;
            String string3 = stringArray[n++];
            this.log.debug((Object)("Looking to context for path = " + string3));
            try {
                object = context2.lookup(string3);
            }
            catch (NamingException namingException) {
                this.log.warning((Object)namingException);
            }
            if (object == null) {
                this.log.debug((Object)("Nothing found for path = " + string3));
                bl = true;
                continue;
            }
            if (object instanceof Context) {
                this.log.debug((Object)("Found something which is a Context for path = " + string3));
                context2 = (Context)object;
                if (n != stringArray.length) continue;
                this.log.debug((Object)("Last entry, this is the context we return for path = " + string3));
                context = context2;
                bl = true;
                continue;
            }
            this.log.debug((Object)("Found something which is not a Context for path = " + string3));
            bl = true;
        }
        return context;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("jndi")) {
            if (!JNDIService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + JNDIService.class.getName());
            }
            this.jndiService = (JNDIService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("jndi");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("jndi")) {
            return this.jndiService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("jndi")) {
            this.jndiService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

