/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.cron;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.api.management.binder.EmbeddedServiceBinder;
import org.petalslink.dsb.kernel.api.management.cron.EmbeddedServiceBinderCron;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=EmbeddedServiceBinderCron.class)})
public class EmbeddedServiceBinderCronImpl
implements BindingController,
LifeCycleController,
EmbeddedServiceBinderCron {
    @Requires(name="embeddedservicebinder", signature=EmbeddedServiceBinder.class)
    private EmbeddedServiceBinder embeddedServiceBinder;
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    private ScheduledExecutorService executorService;
    protected boolean oneShot;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.oneShot = false;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    @LifeCycleListener(phase=Phase.START, priority=700)
    public synchronized void execute() {
        if (!this.oneShot) {
            this.startPolling();
            this.oneShot = true;
        } else {
            this.log.warning((Object)"Can not start the job more than once!");
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startPolling() {
        if (this.executorService != null && !this.executorService.isTerminated()) {
            this.executorService.scheduleAtFixedRate(new EmbeddedServiceChecker(), 30L, 120L, TimeUnit.SECONDS);
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopPolling() {
        this.log.debug((Object)"Stopping to watch for embedded services to bind");
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("embeddedservicebinder")) {
            if (!EmbeddedServiceBinder.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EmbeddedServiceBinder.class.getName());
            }
            this.embeddedServiceBinder = (EmbeddedServiceBinder)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("embeddedservicebinder");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("embeddedservicebinder")) {
            return this.embeddedServiceBinder;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("embeddedservicebinder")) {
            this.embeddedServiceBinder = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    class EmbeddedServiceChecker
    implements Runnable {
        public void run() {
            EmbeddedServiceBinderCronImpl.this.log.info((Object)"Looking if there are remaining services");
            Map map = EmbeddedServiceBinderCronImpl.this.embeddedServiceBinder.getServicesToBind();
            if (map != null && map.size() > 0) {
                EmbeddedServiceBinderCronImpl.this.embeddedServiceBinder.bindAll();
            } else {
                EmbeddedServiceBinderCronImpl.this.stopPolling();
            }
        }
    }
}

