/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.cron;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;
import org.petalslink.dsb.kernel.api.management.binder.NewServiceExposer;
import org.petalslink.dsb.kernel.api.management.cron.ServicePoller;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ServicePoller.class)})
public class ServicePollerImpl
implements BindingController,
LifeCycleController,
ServicePoller {
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    @Requires(name="dsb-configuration", signature=DSBConfigurationService.class)
    protected DSBConfigurationService configurationService;
    @Requires(name="new-service-exposer", signature=NewServiceExposer.class)
    protected NewServiceExposer newServiceExposer;
    private ScheduledExecutorService executorService;
    private boolean paused;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Starting...");
            this.log.debug((Object)("Endoints polling will start in " + this.configurationService.getEndpointsPollingDelay() + " seconds "));
            this.log.debug((Object)("Endoints will be polled each " + this.configurationService.getEndpointsPollingPeriod() + " seconds "));
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.paused = false;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
        this.stopPolling();
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void setPeriod(long l, TimeUnit timeUnit) {
        this.log.info((Object)"#setPeriod is not implemented");
    }

    @LifeCycleListener(phase=Phase.START, priority=0)
    public void startPolling() {
        this.log.info((Object)"Start polling for new services");
        if (this.executorService != null && !this.executorService.isTerminated()) {
            this.executorService.scheduleAtFixedRate(new NewServiceChecker(), 5L, this.configurationService.getEndpointsPollingPeriod(), TimeUnit.SECONDS);
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopPolling() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("dsb-configuration")) {
            if (!DSBConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBConfigurationService.class.getName());
            }
            this.configurationService = (DSBConfigurationService)object;
            return;
        }
        if (string.equals("new-service-exposer")) {
            if (!NewServiceExposer.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NewServiceExposer.class.getName());
            }
            this.newServiceExposer = (NewServiceExposer)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("dsb-configuration");
        arrayList.add("new-service-exposer");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("dsb-configuration")) {
            return this.configurationService;
        }
        if (string.equals("new-service-exposer")) {
            return this.newServiceExposer;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("dsb-configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("new-service-exposer")) {
            this.newServiceExposer = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    class NewServiceChecker
    implements Runnable {
        public void run() {
            if (!ServicePollerImpl.this.paused) {
                ServicePollerImpl.this.log.info((Object)"Time to look for new services to expose");
                ServicePollerImpl.this.newServiceExposer.expose();
            } else {
                ServicePollerImpl.this.log.debug((Object)"The cron is paused...");
            }
        }
    }

    class NewServiceCheckerExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        NewServiceCheckerExceptionHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            ServicePollerImpl.this.logger.log(BasicLevel.ERROR, (Object)(String.valueOf(throwable.getMessage()) + " : " + throwable.getCause()));
        }
    }
}

