/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.generator.bpel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.management.deployment.AtomicDeploymentService;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.jbi.JBIFileHelper;
import org.petalslink.dsb.kernel.io.client.ClientFactoryRegistry;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.MessageImpl;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.bpel.api.BPELDeployer;
import org.petalslink.dsb.ws.bpel.api.BPELDescriptor;
import org.petalslink.dsb.ws.bpel.api.LinkedResourceDescriptor;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=BPELDeployer.class)})
public class BPELDeployerImpl
implements BindingController,
LifeCycleController,
BPELDeployer {
    public static final String WORK_DIR = "bpel-generator";
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="atomic-deployment", signature=AtomicDeploymentService.class)
    private AtomicDeploymentService deploymentService;
    private File workPath;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        System.out.println("START");
        this.log = new LoggingUtil(this.logger);
        this.workPath = new File(this.configurationService.getContainerConfiguration().getWorkDirectoryPath(), WORK_DIR);
        if (!this.workPath.exists()) {
            this.workPath.mkdirs();
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        if (this.workPath.exists()) {
            this.workPath.delete();
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    private void storeFiles(File file, BPELDescriptor bPELDescriptor, LinkedResourceDescriptor[] linkedResourceDescriptorArray) {
        File file2 = new File(file, bPELDescriptor.getFileName());
        this.storeFile(file2, bPELDescriptor.getAttachment());
        if (linkedResourceDescriptorArray != null) {
            LinkedResourceDescriptor[] linkedResourceDescriptorArray2 = linkedResourceDescriptorArray;
            int n = linkedResourceDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                LinkedResourceDescriptor linkedResourceDescriptor = linkedResourceDescriptorArray2[n2];
                File file3 = new File(file, linkedResourceDescriptor.getFileName());
                this.storeFile(file3, linkedResourceDescriptor.getResource());
                ++n2;
            }
        }
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private void storeFile(File file, DataHandler dataHandler) {
        if (file != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                dataHandler.writeTo((OutputStream)fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private File getOutputFolder() {
        File file = new File(this.workPath, String.valueOf(UUID.randomUUID().toString()) + "-output");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private File getNewWorkingFolder() {
        File file = new File(this.workPath, UUID.randomUUID().toString());
        file.mkdirs();
        return file;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deploy(BPELDescriptor bPELDescriptor, LinkedResourceDescriptor[] linkedResourceDescriptorArray) throws DSBWebServiceException {
        boolean bl;
        Object object;
        File file;
        File file2;
        block15: {
            file2 = null;
            File file3 = null;
            try {
                try {
                    file3 = this.getNewWorkingFolder();
                    file = this.getOutputFolder();
                    this.storeFiles(file3, bPELDescriptor, linkedResourceDescriptorArray);
                    object = new ServiceEndpoint();
                    String string = String.format("http://petals.ow2.org/generator/%s/", "bpel");
                    object.setEndpointName("GeneratorEndpoint");
                    object.setServiceName(new QName(string, "GeneratorService"));
                    object.setInterfaces(new QName[]{new QName(string, "GeneratorInterface")});
                    Client client = ClientFactoryRegistry.getFactory().getClient(object);
                    MessageImpl messageImpl = new MessageImpl();
                    messageImpl.setEndpoint("GeneratorEndpoint");
                    messageImpl.setInterface(new QName(string, "GeneratorInterface"));
                    messageImpl.setService(new QName(string, "GeneratorService"));
                    messageImpl.setProperty("bpel.generator.in", file3.getAbsolutePath());
                    messageImpl.setProperty("bpel.generator.out", file.getAbsolutePath());
                    client.sendReceive((Message)messageImpl);
                    File[] fileArray = file.listFiles(new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            System.out.println("Got file = " + string);
                            return string.endsWith("zip");
                        }
                    });
                    if (fileArray != null && fileArray.length > 0) {
                        file2 = fileArray[0];
                    }
                    if (file2 == null) {
                        throw new DSBWebServiceException("Unable to generate Service Assembly");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new DSBWebServiceException(exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (file3 == null) throw throwable;
                file3.delete();
                throw throwable;
            }
            {
                Object var11_17 = null;
                if (file3 == null) break block15;
                file3.delete();
            }
        }
        if ((file = JBIFileHelper.readDescriptor((File)file2)) == null) {
            throw new DSBWebServiceException("Can not get the JBI descriptor from generated SA...");
        }
        object = file.getServiceAssembly().getIdentification().getName();
        System.out.println("SA name : " + (String)object);
        if (object == null) {
            throw new DSBWebServiceException("Can not get the JBI service assembly name from generated SA");
        }
        try {
            bl = this.deploymentService.deploy(file2.toURI().toURL());
            if (!bl) {
                this.log.warning((Object)("Failed to deploy the Service Assembly located at '" + file2.toURI()));
                throw new PEtALSWebServiceException("Deployment failure");
            }
            this.log.info((Object)("Service assembly '" + (String)object + "' has been deployed"));
        }
        catch (Exception exception) {
            throw new DSBWebServiceException((Throwable)exception);
        }
        try {
            bl = this.deploymentService.start((String)object);
            if (bl) {
                this.log.info((Object)("Service assembly '" + (String)object + "' has been started"));
                return true;
            }
            this.log.warning((Object)("Failed to start the Service Assembly '" + (String)object + "'"));
            throw new PEtALSWebServiceException("Start failure, the SA can not be started");
        }
        catch (Exception exception) {
            throw new DSBWebServiceException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("atomic-deployment")) {
            if (!AtomicDeploymentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AtomicDeploymentService.class.getName());
            }
            this.deploymentService = (AtomicDeploymentService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("atomic-deployment");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("atomic-deployment")) {
            return this.deploymentService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("atomic-deployment")) {
            this.deploymentService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

