/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.descriptor.original.generated.LinkType;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.endpoint.EndpointOrderer;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.jbi.Adapter;
import org.petalslink.dsb.kernel.api.PetalsService;
import org.petalslink.dsb.kernel.api.messaging.EndpointSearchEngine;
import org.petalslink.dsb.kernel.api.messaging.SearchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointSearchEngineImpl
implements PetalsService,
EndpointSearchEngine {
    private final LoggingUtil log;
    public static final List<Object> DEFAULT_STRATEGY_PARAMETERS = Arrays.asList("highest", new Float(3.0f), new Float(2.0f), new Float(1.0f));
    private static List<Object> defaultStrategyParameters;
    private EndpointOrderer endpointOrderer;
    private Random random;
    private TopologyService topologyService;
    private ConfigurationService configurationService;
    private EndpointRegistry endpointRegistry;

    public EndpointSearchEngineImpl(LoggingUtil loggingUtil) {
        this.log = loggingUtil;
    }

    public void init() throws Exception {
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        try {
            defaultStrategyParameters = EndpointSearchEngineImpl.tokenizeAndAnalyseStrategy(containerConfiguration.getRouterStrategy());
        }
        catch (SearchException searchException) {
            defaultStrategyParameters = DEFAULT_STRATEGY_PARAMETERS;
        }
        this.endpointOrderer = new EndpointOrderer(this.log, containerConfiguration, this.topologyService);
        this.random = new Random();
    }

    public void setup() throws Exception {
    }

    public void shutdown() throws Exception {
    }

    public org.petalslink.dsb.api.ServiceEndpoint getTargetedEndpointFromGivenEndpoint(org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint, String string) throws SearchException {
        this.log.call();
        org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint2 = null;
        if (serviceEndpoint.getType().equals(ServiceEndpoint.EndpointType.INTERNAL.toString())) {
            if (LinkType.SOFT.value().equals(string)) {
                throw new SearchException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' is not a SOFT link");
            }
            serviceEndpoint2 = serviceEndpoint;
        } else if (serviceEndpoint.getType().equals(ServiceEndpoint.EndpointType.LINKED.toString())) {
            if (LinkType.HARD.value().equals(string)) {
                throw new SearchException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' is not an HARD link");
            }
            try {
                ServiceEndpoint serviceEndpoint3 = this.endpointRegistry.getEndpoint(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
                serviceEndpoint2 = Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint3);
            }
            catch (RegistryException registryException) {
                throw new SearchException((Throwable)registryException);
            }
        } else if (serviceEndpoint.getType() == ServiceEndpoint.EndpointType.EXTERNAL.toString()) {
            serviceEndpoint2 = this.findEndpointInRegistry(serviceEndpoint);
        }
        return serviceEndpoint2;
    }

    private org.petalslink.dsb.api.ServiceEndpoint findEndpointInRegistry(org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint) throws SearchException {
        this.log.call();
        org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint2 = null;
        try {
            ServiceEndpoint serviceEndpoint3 = this.endpointRegistry.getEndpoint(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
            serviceEndpoint2 = Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint3);
        }
        catch (RegistryException registryException) {
            throw new SearchException(registryException.getMessage());
        }
        if (serviceEndpoint2 == null) {
            throw new SearchException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' does not match a registered endpoint");
        }
        return serviceEndpoint2;
    }

    public List<org.petalslink.dsb.api.ServiceEndpoint> getTargetedEndpointFromGivenServiceName(QName qName, String string, String string2) throws SearchException {
        this.log.call();
        List<ServiceEndpoint> list = null;
        try {
            list = this.getEnabledEndpoints(kindSearch.SERVICE_SEARCH, qName, string2);
        }
        catch (RegistryException registryException) {
            throw new SearchException((Throwable)registryException);
        }
        List<Object> list2 = EndpointSearchEngineImpl.getAndAnalyseStrategy(string);
        List list3 = null;
        if (list.size() == 1) {
            list3 = new ArrayList<ServiceEndpoint>(1);
            list3.add(list.get(0));
        } else if (list.size() > 1) {
            try {
                list3 = this.endpointOrderer.orderEndpoints(list, null, list2, this.random);
            }
            catch (RoutingException routingException) {
                throw new SearchException((Throwable)routingException);
            }
        }
        if (list3 == null || list3.size() == 0) {
            throw new SearchException("No endpoint found matching the target service '" + qName + "'");
        }
        ArrayList<org.petalslink.dsb.api.ServiceEndpoint> arrayList = new ArrayList<org.petalslink.dsb.api.ServiceEndpoint>();
        for (ServiceEndpoint serviceEndpoint : list3) {
            arrayList.add(Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint));
        }
        return arrayList;
    }

    public List<org.petalslink.dsb.api.ServiceEndpoint> getTargetedEndpointFromGivenInterfaceName(QName qName, String string, String string2) throws SearchException {
        this.log.call();
        List<ServiceEndpoint> list = null;
        try {
            list = this.getEnabledEndpoints(kindSearch.INTERFACE_SEARCH, qName, string2);
        }
        catch (RegistryException registryException) {
            throw new SearchException((Throwable)registryException);
        }
        List<Object> list2 = EndpointSearchEngineImpl.getAndAnalyseStrategy(string);
        List<Object> list3 = null;
        if (list.size() == 1) {
            list3 = new ArrayList<ServiceEndpoint>(1);
            list3.add(list.get(0));
        } else if (list.size() > 1) {
            try {
                list3 = this.endpointOrderer.orderEndpoints(list, null, list2, this.random);
            }
            catch (RoutingException routingException) {
                throw new SearchException((Throwable)routingException);
            }
        }
        if (list3 != null) {
            list3.size();
        }
        ArrayList<org.petalslink.dsb.api.ServiceEndpoint> arrayList = new ArrayList<org.petalslink.dsb.api.ServiceEndpoint>();
        for (ServiceEndpoint serviceEndpoint : list3) {
            arrayList.add(Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint));
        }
        return arrayList;
    }

    public List<ServiceEndpoint> getEnabledEndpoints(kindSearch kindSearch2, QName qName, String string) throws RegistryException {
        this.log.call();
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        ServiceEndpoint[] serviceEndpointArray = null;
        serviceEndpointArray = kindSearch2 == kindSearch.SERVICE_SEARCH ? this.endpointRegistry.getInternalEndpointsForService(qName, LinkType.fromValue((String)string)) : this.endpointRegistry.getInternalEndpointsForInterface(qName, LinkType.fromValue((String)string));
        ServiceEndpoint[] serviceEndpointArray2 = serviceEndpointArray;
        int n = serviceEndpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceEndpoint serviceEndpoint = serviceEndpointArray2[n2];
            arrayList.add(serviceEndpoint);
            ++n2;
        }
        return arrayList;
    }

    private static List<Object> getAndAnalyseStrategy(String string) throws SearchException {
        List<Object> list = string == null ? defaultStrategyParameters : EndpointSearchEngineImpl.tokenizeAndAnalyseStrategy(string);
        return list;
    }

    private static List<Object> tokenizeAndAnalyseStrategy(String string) throws SearchException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return EndpointSearchEngineImpl.analyseStrategy(arrayList);
    }

    private static List<Object> analyseStrategy(List<String> list) throws SearchException {
        ArrayList<Object> arrayList = null;
        try {
            if (list != null && list.size() == 4) {
                try {
                    EndpointOrderer.verifStrategyParameters((String)list.get(0).toLowerCase(), (float)Float.valueOf(list.get(1)).floatValue(), (float)Float.valueOf(list.get(2)).floatValue(), (float)Float.valueOf(list.get(3)).floatValue());
                }
                catch (RoutingException routingException) {
                    throw new SearchException((Throwable)routingException);
                }
            } else {
                throw new SearchException("Invalid Parameters: 4 parameters are required to configure the routing strategy");
            }
            arrayList = new ArrayList<Object>();
            arrayList.add(list.get(0).toLowerCase());
            arrayList.add(Float.valueOf(list.get(1)));
            arrayList.add(Float.valueOf(list.get(2)));
            arrayList.add(Float.valueOf(list.get(3)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SearchException("Impossible to convert the parameters to realize the routing strategy");
        }
        return arrayList;
    }

    public TopologyService getTopologyService() {
        return this.topologyService;
    }

    public void setTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setEndpointRegistry(EndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public List<org.petalslink.dsb.api.ServiceEndpoint> getAll() {
        ArrayList<org.petalslink.dsb.api.ServiceEndpoint> arrayList = new ArrayList<org.petalslink.dsb.api.ServiceEndpoint>();
        try {
            List list = this.endpointRegistry.getEndpoints();
            if (list != null) {
                for (ServiceEndpoint serviceEndpoint : list) {
                    arrayList.add(Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint));
                }
            }
        }
        catch (RegistryException registryException) {
            registryException.printStackTrace();
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum kindSearch {
        SERVICE_SEARCH,
        INTERFACE_SEARCH;

    }
}

