/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.kernel.api.messaging.EndpointSearchEngine;
import org.petalslink.dsb.kernel.api.messaging.SearchException;
import org.petalslink.dsb.kernel.messaging.EndpointSearchEngineImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=EndpointSearchEngine.class)})
public class FractalEndpointSearchEngineImpl
implements BindingController,
LifeCycleController,
EndpointSearchEngine {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    @Requires(name="topology", signature=TopologyService.class)
    private TopologyService topologyService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    private EndpointRegistry endpointRegistry;
    private EndpointSearchEngineImpl delegate;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws Exception {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.delegate = new EndpointSearchEngineImpl(this.log);
        this.delegate.setConfigurationService(this.configurationService);
        this.delegate.setEndpointRegistry(this.endpointRegistry);
        this.delegate.setTopologyService(this.topologyService);
        this.delegate.init();
        this.delegate.setup();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws Exception {
        this.log.debug((Object)"Stopping...");
        this.delegate.shutdown();
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public ServiceEndpoint getTargetedEndpointFromGivenEndpoint(ServiceEndpoint serviceEndpoint, String string) throws SearchException {
        return this.delegate.getTargetedEndpointFromGivenEndpoint(serviceEndpoint, string);
    }

    public String getFcState() {
        return null;
    }

    public List<ServiceEndpoint> getTargetedEndpointFromGivenInterfaceName(QName qName, String string, String string2) throws SearchException {
        return this.delegate.getTargetedEndpointFromGivenInterfaceName(qName, string, string2);
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public List<ServiceEndpoint> getTargetedEndpointFromGivenServiceName(QName qName, String string, String string2) throws SearchException {
        return this.delegate.getTargetedEndpointFromGivenServiceName(qName, string, string2);
    }

    public List<ServiceEndpoint> getAll() {
        return this.delegate.getAll();
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("topology");
        arrayList.add("configuration");
        arrayList.add("endpoint");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("topology")) {
            return this.topologyService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

