/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging.router;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.transport.util.TransportSendContext;
import org.petalslink.dsb.kernel.messaging.router.ReceiverModule;
import org.petalslink.dsb.kernel.messaging.router.RouterModuleManager;
import org.petalslink.dsb.kernel.messaging.router.SenderModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterModuleManagerImpl
implements RouterModuleManager {
    private Map<String, ManagedSenderModule> senders = new TreeMap<String, ManagedSenderModule>(new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return string2.compareTo(string);
        }
    });
    private Map<String, ManagedReceiverModule> receivers = new TreeMap<String, ManagedReceiverModule>(new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return string2.compareTo(string);
        }
    });

    @Override
    public void add(SenderModule senderModule) {
        if (senderModule != null && senderModule.getName() != null) {
            this.senders.put(senderModule.getName(), new ManagedSenderModule(senderModule));
        }
    }

    @Override
    public void add(ReceiverModule receiverModule) {
        if (receiverModule != null && receiverModule.getName() != null) {
            this.receivers.put(receiverModule.getName(), new ManagedReceiverModule(receiverModule));
        }
    }

    @Override
    public List<SenderModule> getSenders() {
        ArrayList<SenderModule> arrayList = new ArrayList<SenderModule>();
        for (SenderModule senderModule : this.senders.values()) {
            arrayList.add(senderModule);
        }
        return arrayList;
    }

    @Override
    public void setSenderState(String string, boolean bl) {
        ManagedSenderModule managedSenderModule = this.senders.get(string);
        if (managedSenderModule != null) {
            managedSenderModule.state = bl;
        }
    }

    @Override
    public void setReceiverState(String string, boolean bl) {
        ManagedReceiverModule managedReceiverModule = this.receivers.get(string);
        if (managedReceiverModule != null) {
            managedReceiverModule.state = bl;
        }
    }

    @Override
    public boolean getReceiverState(String string) {
        ManagedReceiverModule managedReceiverModule = this.receivers.get(string);
        if (managedReceiverModule == null) {
            return false;
        }
        return managedReceiverModule.state;
    }

    @Override
    public boolean getSenderState(String string) {
        ManagedSenderModule managedSenderModule = this.senders.get(string);
        if (managedSenderModule == null) {
            return false;
        }
        return managedSenderModule.state;
    }

    @Override
    public List<ReceiverModule> getReceivers() {
        ArrayList<ReceiverModule> arrayList = new ArrayList<ReceiverModule>();
        for (ReceiverModule receiverModule : this.receivers.values()) {
            arrayList.add(receiverModule);
        }
        return arrayList;
    }

    class ManagedReceiverModule
    implements ReceiverModule {
        private ReceiverModule receiver;
        private boolean state;

        public ManagedReceiverModule(ReceiverModule receiverModule) {
            this.receiver = receiverModule;
            this.state = true;
        }

        public boolean receiveExchange(MessageExchange messageExchange, ComponentContext componentContext) throws RoutingException {
            if (this.state) {
                return this.receiver.receiveExchange(messageExchange, componentContext);
            }
            return true;
        }

        public String getName() {
            return this.receiver.getName();
        }

        public String getDescription() {
            return this.receiver.getDescription();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ManagedSenderModule
    implements SenderModule {
        private SenderModule module;
        boolean state = true;

        public ManagedSenderModule(SenderModule senderModule) {
            this.module = senderModule;
        }

        public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchange messageExchange) throws RoutingException {
            if (this.state) {
                this.module.electEndpoints(map, componentContext, messageExchange);
            }
        }

        @Override
        public String getName() {
            return this.module.getName();
        }

        @Override
        public String getDescription() {
            return this.module.getDescription();
        }
    }
}

