/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging.router.modules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class LoggerModule
implements BindingController,
LifeCycleController,
SenderModule {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchange messageExchange) throws RoutingException {
        this.log.debug((Object)"******************************* Router logs *******************************");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"- Component context : ");
            this.log.debug((Object)componentContext.getAddress());
            this.log.debug((Object)"");
            this.log.debug((Object)"- Consumer endpoint : ");
            if (messageExchange.getConsumerEndpoint() != null) {
                this.log.debug((Object)("  - Endpoint name : " + messageExchange.getConsumerEndpoint().getEndpointName()));
                this.log.debug((Object)("  - Service name : " + messageExchange.getConsumerEndpoint().getServiceName()));
                this.log.debug((Object)("  - Location : " + messageExchange.getConsumerEndpoint().getLocation()));
                this.log.debug((Object)("  - Interfaces : " + messageExchange.getConsumerEndpoint().getInterfacesName()));
            } else {
                this.log.debug((Object)"  - None");
            }
            this.log.debug((Object)"");
            this.log.debug((Object)"- Exchange values : ");
            this.log.debug((Object)("  - Endpoint name : " + messageExchange.getEndpoint()));
            this.log.debug((Object)("  - ID : " + messageExchange.getExchangeId()));
            this.log.debug((Object)("  - Interface name : " + messageExchange.getInterfaceName()));
            this.log.debug((Object)("  - Operation name : " + messageExchange.getOperation()));
            this.log.debug((Object)("  - Pattern : " + messageExchange.getPattern()));
            this.log.debug((Object)("  - Role : " + messageExchange.getRole()));
            this.log.debug((Object)("  - Service name : " + messageExchange.getService()));
            this.log.debug((Object)("  - Status : " + messageExchange.getStatus()));
            this.log.debug((Object)"");
            Iterator<ServiceEndpoint> iterator = map.keySet().iterator();
            if (iterator.hasNext()) {
                this.log.debug((Object)"- Endpoints found :");
            } else {
                this.log.debug((Object)"No endpoints found!");
            }
            while (iterator.hasNext()) {
                ServiceEndpoint serviceEndpoint = iterator.next();
                this.log.debug((Object)("  - Service Endpoint : " + serviceEndpoint));
                TransportSendContext transportSendContext = map.get(serviceEndpoint);
                if (transportSendContext != null) {
                    this.log.debug((Object)("  - Transport Context : " + transportSendContext.transport + ", " + transportSendContext.destination));
                } else {
                    this.log.debug((Object)"Transport Context is null");
                }
                this.log.debug((Object)"--");
            }
            this.log.debug((Object)"***************************************************************************");
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

