/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.NullArgumentException;
import org.ow2.petals.jbi.descriptor.original.generated.LinkType;
import org.ow2.petals.jbi.messaging.endpoint.JBIServiceEndpointImpl;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.kernel.api.service.Location;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.registry.api.Endpoint;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.util.XMLUtil;
import org.ow2.petals.registry.client.api.RegistryClient;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.jbi.Adapter;
import org.petalslink.dsb.kernel.api.messaging.RegistryListener;
import org.petalslink.dsb.kernel.registry.AbstractEndpointRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEndpointRegistry
extends AbstractEndpointRegistry {
    public static final String LISTENER_FRACTAL_PREFIX = "listener";
    protected static final String CONFIG = "/server.properties";
    protected LocalRegistry registry;
    protected RegistryClient client;

    public ServiceEndpoint activateEndpoint(QName qName, String string, ServiceEndpoint serviceEndpoint) throws RegistryException {
        return this.activateEndpoint(qName, string, null, null, serviceEndpoint, null);
    }

    public ServiceEndpoint activateEndpoint(QName qName, String string, QName[] qNameArray, Document document, ServiceEndpoint serviceEndpoint, Map<String, String> map) throws RegistryException {
        JBIServiceEndpointImpl jBIServiceEndpointImpl = new JBIServiceEndpointImpl();
        jBIServiceEndpointImpl.setServiceName(qName);
        jBIServiceEndpointImpl.setEndpointName(string);
        jBIServiceEndpointImpl.setInterfacesName(Arrays.asList(qNameArray));
        jBIServiceEndpointImpl.setLocation(serviceEndpoint.getLocation());
        jBIServiceEndpointImpl.setDescription(document);
        jBIServiceEndpointImpl.setProperties(map);
        this.registerEndpoint((ServiceEndpoint)jBIServiceEndpointImpl);
        if (this.getList() != null) {
            for (RegistryListener registryListener : this.getList()) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Calling registry listener '" + registryListener.getName() + "' on new endpoint"));
                    }
                    registryListener.onRegister(Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)jBIServiceEndpointImpl));
                }
                catch (DSBException dSBException) {
                    this.log.warning((Object)"Got an error while calling registry listener", (Throwable)dSBException);
                }
            }
        }
        return jBIServiceEndpointImpl;
    }

    protected void registerEndpoint(ServiceEndpoint serviceEndpoint) throws RegistryException {
        if (serviceEndpoint == null) {
            throw new RegistryException("Can not register a null service endpoint");
        }
        Endpoint endpoint = new Endpoint();
        if (serviceEndpoint.getDescription() != null) {
            try {
                endpoint.setDescription(XMLUtil.createStringFromDOMDocument((Node)serviceEndpoint.getDescription()));
            }
            catch (TransformerException transformerException) {
                this.log.warning((Object)transformerException.getMessage());
            }
        }
        if (serviceEndpoint.getEndpointName() != null) {
            endpoint.setName(QName.valueOf(serviceEndpoint.getEndpointName()));
        }
        if (serviceEndpoint.getInterfaces() != null) {
            endpoint.setInterface(serviceEndpoint.getInterfaces()[0]);
        }
        endpoint.setService(serviceEndpoint.getServiceName());
        if (serviceEndpoint.getLocation() != null) {
            endpoint.setComponent(serviceEndpoint.getLocation().getComponentName());
            endpoint.setContainer(serviceEndpoint.getLocation().getContainerName());
            endpoint.setSubdomain(serviceEndpoint.getLocation().getSubdomainName());
        }
        endpoint.setType(serviceEndpoint.getType().toString().toLowerCase());
        try {
            this.client.put(this.getKey(serviceEndpoint), endpoint, true);
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
    }

    public void deactivateEndpoint(String string, QName qName) throws RegistryException {
        if (string == null || qName == null) {
            throw new RegistryException("Can not deactivate null endpoint");
        }
        Endpoint endpoint = null;
        String string2 = this.getKey(string, qName);
        try {
            endpoint = this.client.get(string2, true);
            if (endpoint == null) {
                throw new RegistryException("Can not unregister not registered endpoint...");
            }
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
        try {
            this.client.delete(string2, true);
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException("Can not delete endpoint under " + string2, (Throwable)registryException);
        }
        List list = this.getList();
        if (list != null) {
            JBIServiceEndpointImpl jBIServiceEndpointImpl = new JBIServiceEndpointImpl();
            jBIServiceEndpointImpl.setServiceName(endpoint.getService());
            jBIServiceEndpointImpl.setEndpointName(endpoint.getName());
            ArrayList<QName> arrayList = new ArrayList<QName>(1);
            arrayList.add(endpoint.getInterface());
            jBIServiceEndpointImpl.setInterfacesName(arrayList);
            jBIServiceEndpointImpl.setStringDescription(endpoint.getDescription());
            for (RegistryListener registryListener : list) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Calling registry listener '" + registryListener.getName() + "' on endpoint unregistration"));
                    }
                    registryListener.onUnregister(Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)jBIServiceEndpointImpl));
                }
                catch (DSBException dSBException) {
                    this.log.warning((Object)"Got an error while calling registry listener", (Throwable)dSBException);
                }
            }
        }
    }

    public void deregisterConnection(QName qName, QName qName2, String string) throws RegistryException {
        throw new NotImplementedException();
    }

    public void deregisterConnection(QName qName, String string, QName qName2, String string2) throws RegistryException {
        throw new NotImplementedException();
    }

    public void deregisterExternalEndpoint(String string, QName qName) throws RegistryException {
        this.deactivateEndpoint(string, qName);
    }

    public ServiceEndpoint getEndpoint(QName qName, String string) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getEndpoint with params service, name = " + qName + ", " + string));
        }
        JBIServiceEndpointImpl jBIServiceEndpointImpl = null;
        Query query = new Query();
        query.setEndpoint(QName.valueOf(string));
        query.setService(qName);
        try {
            List list = this.client.lookup(query, false);
            if (list != null && list.size() > 0) {
                Endpoint endpoint = (Endpoint)list.get(0);
                if (endpoint.getType() != null && endpoint.getType().equalsIgnoreCase(ServiceEndpoint.EndpointType.EXTERNAL.toString().toLowerCase())) {
                    JBIServiceEndpointImpl jBIServiceEndpointImpl2 = new JBIServiceEndpointImpl();
                    jBIServiceEndpointImpl2.setType(ServiceEndpoint.EndpointType.EXTERNAL);
                    jBIServiceEndpointImpl2.setStringDescription(endpoint.getDescription());
                    jBIServiceEndpointImpl2.setEndpointName(endpoint.getName().toString());
                    ArrayList<QName> arrayList = new ArrayList<QName>(1);
                    arrayList.add(endpoint.getInterface());
                    jBIServiceEndpointImpl2.setInterfacesName(arrayList);
                    jBIServiceEndpointImpl2.setServiceName(endpoint.getService());
                    jBIServiceEndpointImpl2.getLocation().setComponentName(endpoint.getComponent());
                    jBIServiceEndpointImpl2.getLocation().setContainerName(endpoint.getContainer());
                    jBIServiceEndpointImpl2.getLocation().setSubdomainName(endpoint.getSubdomain());
                    jBIServiceEndpointImpl = jBIServiceEndpointImpl2;
                } else if (endpoint.getType() != null && endpoint.getType().equalsIgnoreCase(ServiceEndpoint.EndpointType.INTERNAL.toString().toLowerCase())) {
                    JBIServiceEndpointImpl jBIServiceEndpointImpl3 = new JBIServiceEndpointImpl();
                    jBIServiceEndpointImpl3.setType(ServiceEndpoint.EndpointType.INTERNAL);
                    jBIServiceEndpointImpl3.setStringDescription(endpoint.getDescription());
                    jBIServiceEndpointImpl3.setEndpointName(endpoint.getName().toString());
                    ArrayList<QName> arrayList = new ArrayList<QName>(1);
                    arrayList.add(endpoint.getInterface());
                    jBIServiceEndpointImpl3.setInterfacesName(arrayList);
                    jBIServiceEndpointImpl3.setServiceName(endpoint.getService());
                    jBIServiceEndpointImpl3.getLocation().setComponentName(endpoint.getComponent());
                    jBIServiceEndpointImpl3.getLocation().setContainerName(endpoint.getContainer());
                    jBIServiceEndpointImpl3.getLocation().setSubdomainName(endpoint.getSubdomain());
                    jBIServiceEndpointImpl = jBIServiceEndpointImpl3;
                } else {
                    this.log.warning((Object)("UNKNOW EP TYPE " + endpoint.getType()));
                }
            }
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
        return jBIServiceEndpointImpl;
    }

    public Document getEndpointDescriptorForEndpoint(ServiceEndpoint serviceEndpoint) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getEndpointDescriptorForEndpoint with params endpoint = " + serviceEndpoint));
        }
        if (serviceEndpoint == null) {
            throw new RegistryException("Null endpoint");
        }
        Document document = serviceEndpoint.getDescription();
        if (document == null) {
            try {
                Endpoint endpoint = this.client.get(this.getKey(serviceEndpoint), true);
                if (endpoint != null && endpoint.getDescription() != null) {
                    document = XMLUtil.createDocumentFromString((String)endpoint.getDescription());
                }
            }
            catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
                throw new RegistryException(registryException.getMessage());
            }
        }
        return document;
    }

    public ServiceEndpoint[] getExternalEndpointsForInterface(QName qName) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getExternalEndpointsForInterface with params interfaceName = " + qName));
        }
        ServiceEndpoint[] serviceEndpointArray = new ServiceEndpoint[]{};
        Query query = new Query();
        query.setInterface(qName);
        query.setType(ServiceEndpoint.EndpointType.EXTERNAL.toString().toLowerCase());
        try {
            List list = this.client.lookup(query, false);
            if (list != null) {
                ArrayList<JBIServiceEndpointImpl> arrayList = new ArrayList<JBIServiceEndpointImpl>(list.size());
                for (Endpoint endpoint : list) {
                    JBIServiceEndpointImpl jBIServiceEndpointImpl = new JBIServiceEndpointImpl();
                    jBIServiceEndpointImpl.setType(ServiceEndpoint.EndpointType.EXTERNAL);
                    jBIServiceEndpointImpl.setStringDescription(endpoint.getDescription());
                    jBIServiceEndpointImpl.setEndpointName(endpoint.getName().toString());
                    ArrayList<QName> arrayList2 = new ArrayList<QName>(1);
                    arrayList2.add(endpoint.getInterface());
                    jBIServiceEndpointImpl.setInterfacesName(arrayList2);
                    jBIServiceEndpointImpl.setServiceName(endpoint.getService());
                    jBIServiceEndpointImpl.getLocation().setComponentName(endpoint.getComponent());
                    jBIServiceEndpointImpl.getLocation().setContainerName(endpoint.getContainer());
                    jBIServiceEndpointImpl.getLocation().setSubdomainName(endpoint.getSubdomain());
                    arrayList.add(jBIServiceEndpointImpl);
                }
                serviceEndpointArray = arrayList.toArray(new ServiceEndpoint[arrayList.size()]);
            }
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
        return serviceEndpointArray;
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName qName) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getExternalEndpointsForService with params serviceName = " + qName));
        }
        if (qName == null) {
            throw new NullArgumentException("serviceName");
        }
        ServiceEndpoint[] serviceEndpointArray = new ServiceEndpoint[]{};
        Query query = new Query();
        query.setService(qName);
        query.setType(ServiceEndpoint.EndpointType.EXTERNAL.toString().toLowerCase());
        try {
            List list = this.client.lookup(query, false);
            if (list != null) {
                ArrayList<JBIServiceEndpointImpl> arrayList = new ArrayList<JBIServiceEndpointImpl>(list.size());
                for (Endpoint endpoint : list) {
                    JBIServiceEndpointImpl jBIServiceEndpointImpl = new JBIServiceEndpointImpl();
                    jBIServiceEndpointImpl.setType(ServiceEndpoint.EndpointType.EXTERNAL);
                    jBIServiceEndpointImpl.setStringDescription(endpoint.getDescription());
                    jBIServiceEndpointImpl.setEndpointName(endpoint.getName().toString());
                    ArrayList<QName> arrayList2 = new ArrayList<QName>(1);
                    arrayList2.add(endpoint.getInterface());
                    jBIServiceEndpointImpl.setInterfacesName(arrayList2);
                    jBIServiceEndpointImpl.setServiceName(endpoint.getService());
                    jBIServiceEndpointImpl.getLocation().setComponentName(endpoint.getComponent());
                    jBIServiceEndpointImpl.getLocation().setContainerName(endpoint.getContainer());
                    jBIServiceEndpointImpl.getLocation().setSubdomainName(endpoint.getSubdomain());
                    arrayList.add(jBIServiceEndpointImpl);
                }
                serviceEndpointArray = arrayList.toArray(new ServiceEndpoint[arrayList.size()]);
            }
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
        return serviceEndpointArray;
    }

    public QName[] getInterfacesForEndpoint(ServiceEndpoint serviceEndpoint) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getInterfacesForEndpoint with params endpoint = " + serviceEndpoint));
        }
        if (serviceEndpoint == null) {
            throw new NullArgumentException("endpoint");
        }
        QName[] qNameArray = null;
        if (serviceEndpoint.getInterfaces() == null) {
            try {
                Endpoint endpoint = this.client.get(this.getKey(serviceEndpoint), true);
                if (endpoint != null && endpoint.getInterface() != null) {
                    qNameArray = serviceEndpoint.getInterfaces();
                }
            }
            catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
                registryException.printStackTrace();
            }
        }
        return qNameArray;
    }

    public ServiceEndpoint[] getInternalEndpointsForInterface(QName qName, LinkType linkType) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getInternalEndpointsForInterface with params interfaceName, linktype = " + qName + ", " + linkType));
        }
        ServiceEndpoint[] serviceEndpointArray = new ServiceEndpoint[]{};
        Query query = new Query();
        query.setInterface(qName);
        query.setType(ServiceEndpoint.EndpointType.INTERNAL.toString().toLowerCase());
        try {
            List list = this.client.lookup(query, false);
            if (list != null) {
                ArrayList<JBIServiceEndpointImpl> arrayList = new ArrayList<JBIServiceEndpointImpl>(list.size());
                for (Endpoint endpoint : list) {
                    JBIServiceEndpointImpl jBIServiceEndpointImpl = new JBIServiceEndpointImpl();
                    jBIServiceEndpointImpl.setType(ServiceEndpoint.EndpointType.INTERNAL);
                    jBIServiceEndpointImpl.setStringDescription(endpoint.getDescription());
                    jBIServiceEndpointImpl.setEndpointName(endpoint.getName().toString());
                    ArrayList<QName> arrayList2 = new ArrayList<QName>(1);
                    arrayList2.add(endpoint.getInterface());
                    jBIServiceEndpointImpl.setInterfacesName(arrayList2);
                    jBIServiceEndpointImpl.setServiceName(endpoint.getService());
                    jBIServiceEndpointImpl.getLocation().setComponentName(endpoint.getComponent());
                    jBIServiceEndpointImpl.getLocation().setContainerName(endpoint.getContainer());
                    jBIServiceEndpointImpl.getLocation().setSubdomainName(endpoint.getSubdomain());
                    arrayList.add(jBIServiceEndpointImpl);
                }
                serviceEndpointArray = arrayList.toArray(new ServiceEndpoint[arrayList.size()]);
            }
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            this.log.warning((Object)("Fail to get endpoints for interface '" + qName + "'"));
            throw new RegistryException((Throwable)registryException);
        }
        return serviceEndpointArray;
    }

    public ServiceEndpoint[] getInternalEndpointsForService(QName qName, LinkType linkType) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getInternalEndpointsForService with params serviceName, linktype = " + qName + ", " + linkType));
        }
        if (qName == null) {
            throw new RegistryException("No serviceName found");
        }
        ServiceEndpoint[] serviceEndpointArray = new ServiceEndpoint[]{};
        Query query = new Query();
        query.setService(qName);
        query.setType(ServiceEndpoint.EndpointType.INTERNAL.toString().toLowerCase());
        try {
            List list = this.client.lookup(query, false);
            if (list != null) {
                ArrayList<JBIServiceEndpointImpl> arrayList = new ArrayList<JBIServiceEndpointImpl>(list.size());
                for (Endpoint endpoint : list) {
                    JBIServiceEndpointImpl jBIServiceEndpointImpl = new JBIServiceEndpointImpl();
                    jBIServiceEndpointImpl.setType(ServiceEndpoint.EndpointType.INTERNAL);
                    jBIServiceEndpointImpl.setStringDescription(endpoint.getDescription());
                    jBIServiceEndpointImpl.setEndpointName(endpoint.getName().toString());
                    ArrayList<QName> arrayList2 = new ArrayList<QName>(1);
                    arrayList2.add(endpoint.getInterface());
                    jBIServiceEndpointImpl.setInterfacesName(arrayList2);
                    jBIServiceEndpointImpl.setServiceName(endpoint.getService());
                    jBIServiceEndpointImpl.getLocation().setComponentName(endpoint.getComponent());
                    jBIServiceEndpointImpl.getLocation().setContainerName(endpoint.getContainer());
                    jBIServiceEndpointImpl.getLocation().setSubdomainName(endpoint.getSubdomain());
                    arrayList.add(jBIServiceEndpointImpl);
                }
                serviceEndpointArray = arrayList.toArray(new ServiceEndpoint[arrayList.size()]);
            }
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
        return serviceEndpointArray;
    }

    public void registerConnection(QName qName, QName qName2, String string) throws RegistryException {
        throw new NotImplementedException();
    }

    public void registerConnection(QName qName, String string, QName qName2, String string2) throws RegistryException {
        throw new NotImplementedException();
    }

    public void registerExternalEndpoint(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : registerExternalEndpoint with params externalEndpoint = " + serviceEndpoint));
        }
        if (serviceEndpoint == null) {
            throw new RegistryException("Can not register a null external endpoint");
        }
        if (!(serviceEndpoint instanceof ServiceEndpoint)) {
            this.log.warning((Object)"Trying to register a bad external service endpoint");
            throw new RegistryException("Bad external service endpoint type");
        }
        this.registerEndpoint((ServiceEndpoint)serviceEndpoint);
    }

    public Document getDescription(String string, String string2) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getDescription with params serviceName, endpointName = " + string + ", " + string2));
        }
        final String string3 = string;
        final String string4 = string2;
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint(){

            public QName getServiceName() {
                return QName.valueOf(string3);
            }

            public QName[] getInterfaces() {
                return null;
            }

            public String getEndpointName() {
                return string4;
            }

            public DocumentFragment getAsReference(QName qName) {
                return null;
            }

            public ServiceEndpoint.EndpointType getType() {
                return null;
            }

            public Document getDescription() {
                return null;
            }

            public List<QName> getInterfacesName() {
                return null;
            }

            public Location getLocation() {
                return null;
            }

            public void setType(ServiceEndpoint.EndpointType endpointType) {
            }

            public Map<String, String> getProperties() {
                return null;
            }
        };
        return this.getEndpointDescriptorForEndpoint(serviceEndpoint);
    }

    private String getKey(ServiceEndpoint serviceEndpoint) {
        return this.getKey(serviceEndpoint.getEndpointName(), serviceEndpoint.getServiceName());
    }

    protected String getKey(String string, QName qName) {
        String string2 = this.getRootPath();
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "/";
        }
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(string2) + "/";
        }
        return String.valueOf(string2) + qName.toString() + "@" + string;
    }

    protected abstract String getRootPath();

    public List<ServiceEndpoint> getExternalEndpoints() throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entering method : getExternalEndpoints");
        }
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        Query query = new Query();
        query.setType(ServiceEndpoint.EndpointType.EXTERNAL.toString().toLowerCase());
        try {
            List list = this.client.lookup(query, true);
            for (Endpoint endpoint : list) {
                JBIServiceEndpointImpl jBIServiceEndpointImpl = new JBIServiceEndpointImpl();
                jBIServiceEndpointImpl.setType(ServiceEndpoint.EndpointType.EXTERNAL);
                jBIServiceEndpointImpl.setStringDescription(endpoint.getDescription());
                jBIServiceEndpointImpl.setEndpointName(endpoint.getName().toString());
                ArrayList<QName> arrayList2 = new ArrayList<QName>(1);
                arrayList2.add(endpoint.getInterface());
                jBIServiceEndpointImpl.setInterfacesName(arrayList2);
                jBIServiceEndpointImpl.setServiceName(endpoint.getService());
                jBIServiceEndpointImpl.getLocation().setComponentName(endpoint.getComponent());
                jBIServiceEndpointImpl.getLocation().setContainerName(endpoint.getContainer());
                jBIServiceEndpointImpl.getLocation().setSubdomainName(endpoint.getSubdomain());
                arrayList.add((ServiceEndpoint)jBIServiceEndpointImpl);
            }
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
        return arrayList;
    }

    public List<ServiceEndpoint> getInternalEndpoints() throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entering method : getInternalEndpoints");
        }
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        Query query = new Query();
        query.setType(ServiceEndpoint.EndpointType.INTERNAL.toString().toLowerCase());
        try {
            List list = this.client.lookup(query, true);
            for (Endpoint endpoint : list) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found internal endoint : " + endpoint));
                }
                JBIServiceEndpointImpl jBIServiceEndpointImpl = new JBIServiceEndpointImpl();
                jBIServiceEndpointImpl.setType(ServiceEndpoint.EndpointType.INTERNAL);
                jBIServiceEndpointImpl.setStringDescription(endpoint.getDescription());
                jBIServiceEndpointImpl.setEndpointName(endpoint.getName().toString());
                ArrayList<QName> arrayList2 = new ArrayList<QName>(1);
                arrayList2.add(endpoint.getInterface());
                jBIServiceEndpointImpl.setInterfacesName(arrayList2);
                jBIServiceEndpointImpl.setServiceName(endpoint.getService());
                jBIServiceEndpointImpl.getLocation().setComponentName(endpoint.getComponent());
                jBIServiceEndpointImpl.getLocation().setContainerName(endpoint.getContainer());
                jBIServiceEndpointImpl.getLocation().setSubdomainName(endpoint.getSubdomain());
                arrayList.add((ServiceEndpoint)jBIServiceEndpointImpl);
            }
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
        return arrayList;
    }

    public List<ServiceEndpoint> query(String string, QName qName, QName qName2, String string2, String string3, String string4, String string5) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entering method : query");
        }
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        Query query = new Query();
        if (string != null) {
            query.setEndpoint(QName.valueOf(string));
        }
        query.setInterface(qName);
        query.setService(qName2);
        query.setContainer(string2);
        query.setComponent(string3);
        query.setSubDomain(string4);
        query.setType(string5);
        try {
            List list = this.client.lookup(query, true);
            for (Endpoint endpoint : list) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found endoint : " + endpoint));
                }
                JBIServiceEndpointImpl jBIServiceEndpointImpl = new JBIServiceEndpointImpl();
                jBIServiceEndpointImpl.setType(ServiceEndpoint.EndpointType.INTERNAL);
                jBIServiceEndpointImpl.setStringDescription(endpoint.getDescription());
                jBIServiceEndpointImpl.setEndpointName(endpoint.getName().toString());
                ArrayList<QName> arrayList2 = new ArrayList<QName>(1);
                arrayList2.add(endpoint.getInterface());
                jBIServiceEndpointImpl.setInterfacesName(arrayList2);
                jBIServiceEndpointImpl.setServiceName(endpoint.getService());
                jBIServiceEndpointImpl.getLocation().setComponentName(endpoint.getComponent());
                jBIServiceEndpointImpl.getLocation().setContainerName(endpoint.getContainer());
                jBIServiceEndpointImpl.getLocation().setSubdomainName(endpoint.getSubdomain());
                arrayList.add((ServiceEndpoint)jBIServiceEndpointImpl);
            }
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
        return arrayList;
    }

    public void removeAllLocalEndpoints() throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entering method : removeAllLocalEndpoints");
        }
        try {
            this.client.delete(this.getRootPath(), true);
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException.getMessage());
        }
    }
}

