/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.registry;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.registry.RegistryListener;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.fractal.utils.FractalHelper;
import org.petalslink.dsb.kernel.api.messaging.RegistryListenerManager;
import org.petalslink.dsb.kernel.api.messaging.RegistryListenerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RegistryListenerRegistry.class)})
public class RegistryListenerRegistryImpl
implements BindingController,
LifeCycleController,
RegistryListenerRegistry {
    private Logger logger;
    private LoggingUtil log;
    private Component component;
    @Requires(name="registry-listener-manager", signature=RegistryListenerManager.class)
    protected RegistryListenerManager registryListenerManager;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        System.out.println("INIT " + this.getClass().getCanonicalName());
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycleListener(priority=10000)
    public void initialize() {
        List<org.petalslink.dsb.kernel.api.messaging.RegistryListener> list = this.getListeners();
        if (list != null) {
            for (org.petalslink.dsb.kernel.api.messaging.RegistryListener registryListener : list) {
                try {
                    this.registryListenerManager.add(registryListener);
                }
                catch (DSBException dSBException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error((Object)"Error while adding registry listener", (Throwable)dSBException);
                        continue;
                    }
                    this.log.debug((Object)"Error while adding registry listener");
                }
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public List<org.petalslink.dsb.kernel.api.messaging.RegistryListener> getListeners() {
        ArrayList<org.petalslink.dsb.kernel.api.messaging.RegistryListener> arrayList = new ArrayList<org.petalslink.dsb.kernel.api.messaging.RegistryListener>();
        List list = FractalHelper.getAllComponentsWithAnnotation((ContentController)FractalHelper.getContentController((Component)FractalHelper.getRootComponent((Component)this.component)), RegistryListener.class);
        for (Component component : list) {
            Object object = FractalHelper.getContent((Component)component);
            if (!(object instanceof org.petalslink.dsb.kernel.api.messaging.RegistryListener)) continue;
            org.petalslink.dsb.kernel.api.messaging.RegistryListener registryListener = (org.petalslink.dsb.kernel.api.messaging.RegistryListener)object;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Got a registry listener detected from the framework : %s", registryListener.getName()));
            }
            arrayList.add(registryListener);
        }
        return arrayList;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("registry-listener-manager")) {
            if (!RegistryListenerManager.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RegistryListenerManager.class.getName());
            }
            this.registryListenerManager = (RegistryListenerManager)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("registry-listener-manager");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("registry-listener-manager")) {
            return this.registryListenerManager;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("registry-listener-manager")) {
            this.registryListenerManager = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

