/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.cxf.message.Message;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.kernel.api.service.Location;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.io.Constants;
import org.petalslink.dsb.kernel.service.EndpointHelper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class CoreServiceRouterModule
implements BindingController,
LifeCycleController,
SenderModule {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    @Requires(name="topology", signature=TopologyService.class)
    private TopologyService topologyService;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.end();
    }

    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchange messageExchange) throws RoutingException {
        NormalizedMessage normalizedMessage = messageExchange.getMessage("in");
        if (normalizedMessage != null && normalizedMessage.getProperty(Constants.MESSAGE_TYPE) != null && normalizedMessage.getProperty(Constants.MESSAGE_TYPE).equals("dsb_invoke") && MessageExchange.Role.CONSUMER.equals(messageExchange.getRole())) {
            List<ServiceEndpoint> list = this.resolve(componentContext, messageExchange);
            for (ServiceEndpoint serviceEndpoint : list) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found an endpoint for kernel Service : " + serviceEndpoint));
                }
                map.put(serviceEndpoint, new TransportSendContext(serviceEndpoint.getLocation()));
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public List<ServiceEndpoint> resolve(ComponentContext componentContext, MessageExchange messageExchange) {
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        NormalizedMessage normalizedMessage = messageExchange.getMessage("in");
        String string = normalizedMessage.getProperty(Message.ENDPOINT_ADDRESS) != null ? normalizedMessage.getProperty(Message.ENDPOINT_ADDRESS).toString() : null;
        final String string2 = normalizedMessage.getProperty(Constants.SERVICE_NAME).toString();
        final String string3 = normalizedMessage.getProperty(Constants.ENDPOINT_NAME).toString();
        final String string4 = normalizedMessage.getProperty(Constants.ITF_NAME).toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Found this in the message : ");
            this.log.debug((Object)("ENDOINT = " + string3));
            this.log.debug((Object)("SERVICE = " + string2));
            this.log.debug((Object)("INTERFACE = " + string4));
        }
        String string5 = EndpointHelper.getInstance().getHost(string);
        Location location = null;
        if (string5 != null && (location = this.getLocation(string5)) != null) {
            final Location location2 = location;
            ServiceEndpoint serviceEndpoint = new ServiceEndpoint(){

                public void setType(ServiceEndpoint.EndpointType endpointType) {
                }

                public ServiceEndpoint.EndpointType getType() {
                    return ServiceEndpoint.EndpointType.INTERNAL;
                }

                public Location getLocation() {
                    return location2;
                }

                public List<QName> getInterfacesName() {
                    return Arrays.asList(this.getInterfaces());
                }

                public Document getDescription() {
                    return null;
                }

                public QName getServiceName() {
                    return QName.valueOf(string2);
                }

                public QName[] getInterfaces() {
                    return new QName[]{QName.valueOf(string4)};
                }

                public String getEndpointName() {
                    return QName.valueOf(string3).getLocalPart();
                }

                public DocumentFragment getAsReference(QName qName) {
                    return null;
                }
            };
            arrayList.add(serviceEndpoint);
        }
        return arrayList;
    }

    private Location getLocation(String string) {
        ContainerConfiguration containerConfiguration = this.topologyService.getContainerConfiguration(string);
        if (containerConfiguration == null) {
            return null;
        }
        Location location = new Location();
        location.setComponentName("dsb-kernelservice-component");
        location.setContainerName(string);
        location.setSubdomainName(containerConfiguration.getSubdomainName());
        return location;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("topology");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("topology")) {
            return this.topologyService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

