/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.service;

import java.util.ArrayList;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.kernel.api.service.Server;
import org.petalslink.dsb.kernel.api.service.ServiceServer;
import org.petalslink.dsb.kernel.service.CoreServiceManagerImpl;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.api.HelloService;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ServiceServer.class)})
public class ServiceServerImpl
implements BindingController,
LifeCycleController,
ServiceServer {
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    private Logger logger;
    private LoggingUtil log;
    private Server server;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
        this.log.end();
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (DSBException dSBException) {
                dSBException.printStackTrace();
            }
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycleListener(phase=Phase.START, priority=102)
    public void expose() {
    }

    protected void doTestExpose() {
        if (this.configurationService.getContainerConfiguration().getName().equals("0")) {
            CoreServiceManagerImpl coreServiceManagerImpl = new CoreServiceManagerImpl();
            this.server = coreServiceManagerImpl.createService(HelloService.class, new HelloService(){

                public String sayHello(String string) throws DSBWebServiceException {
                    System.out.println("SAY HELLO IS INVOKED ON SERVER!!!");
                    return "You said : " + string;
                }
            }, this.configurationService.getContainerConfiguration().getName());
        } else {
            System.out.println(">>> Server, not the right node");
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

