/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.tools.remote;

import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.Service;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.petalslink.dsb.fractal.utils.FractalHelper;
import org.petalslink.dsb.kernel.api.tools.remote.ContainerWebServiceExposer;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceException;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceExposer;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceInformationBean;
import org.petalslink.dsb.kernel.tools.remote.ComponentAddressResolver;
import org.petalslink.dsb.kernel.tools.ws.FractalWSHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllJAXWSContainerWebServiceExposerImpl
implements BindingController,
ContainerWebServiceExposer {
    @Requires(name="webserviceexposer", signature=WebServiceExposer.class)
    private WebServiceExposer webServiceExposer;
    @Service(name="component")
    private Component component;
    private Logger logger;
    @Requires(name="configuration", signature=ContainerConfiguration.class)
    private ContainerConfiguration containerConfiguration;
    private LoggerFactory loggerFactory;

    public void expose() {
        Set<WebServiceInformationBean> set = this.getAllWebServiceInformationBean();
        for (WebServiceInformationBean webServiceInformationBean : set) {
            webServiceInformationBean.setUrl(this.getURL(webServiceInformationBean));
        }
        try {
            this.webServiceExposer.expose(set);
        }
        catch (WebServiceException webServiceException) {
            webServiceException.printStackTrace();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private String getURL(WebServiceInformationBean webServiceInformationBean) {
        return ComponentAddressResolver.getComponentAddress(this.containerConfiguration, webServiceInformationBean.getClazz());
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private Set<WebServiceInformationBean> getAllWebServiceInformationBean() {
        Component component = FractalHelper.getRootComponent((Component)this.component);
        try {
            return FractalWSHelper.getAllBeans(Fractal.getContentController((Component)component));
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            noSuchInterfaceException.printStackTrace();
            return null;
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public String[] listFc() {
        return new String[0];
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

