/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.tools.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.kernel.tools.service.ServiceExposer;
import org.petalslink.dsb.kernel.tools.service.ServiceRegistry;
import org.petalslink.dsb.soap.CXFExposer;
import org.petalslink.dsb.soap.api.Exposer;
import org.petalslink.dsb.soap.api.Service;
import org.petalslink.dsb.soap.api.ServiceException;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ServiceExposer.class)})
public class CXFServiceExposerImpl
implements BindingController,
LifeCycleController,
ServiceExposer {
    private Logger logger;
    private LoggingUtil log;
    private Exposer exposer;
    private Map<String, org.petalslink.dsb.commons.service.api.Service> exposed;
    @Requires(name="registry", signature=ServiceRegistry.class)
    private ServiceRegistry registry;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.exposer = new CXFExposer();
        this.exposed = new HashMap<String, org.petalslink.dsb.commons.service.api.Service>();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        for (org.petalslink.dsb.commons.service.api.Service service : this.exposed.values()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Stopping a service...");
            }
            service.stop();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycleListener(priority=0)
    public void expose() throws DSBException {
        List<Service> list = this.registry.getServices();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Got %d services to expose", list.size()));
        }
        if (list != null) {
            for (Service service : list) {
                try {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"Exposing service...");
                    }
                    org.petalslink.dsb.commons.service.api.Service service2 = this.exposer.expose(service);
                    service2.start();
                    this.exposed.put(service2.getURL(), service2);
                    this.log.info((Object)String.format("Service is exposed and is available as Web service at %s", service.getURL()));
                }
                catch (ServiceException serviceException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.warning((Object)"Problem while exposing service", (Throwable)serviceException);
                    } else {
                        this.log.warning((Object)"Problem while exposing service");
                    }
                    serviceException.printStackTrace();
                }
                catch (Exception exception) {
                    if (this.log.isDebugEnabled()) {
                        this.log.warning((Object)"Unknown problem while exposing service", (Throwable)exception);
                    } else {
                        this.log.warning((Object)"Unknown problem while exposing service");
                    }
                    exception.printStackTrace();
                }
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("registry")) {
            if (!ServiceRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServiceRegistry.class.getName());
            }
            this.registry = (ServiceRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("registry");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("registry")) {
            return this.registry;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("registry")) {
            this.registry = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

