/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.tools.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.tools.ws.WebServiceHelper;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceInformationBean;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=WebServiceRegistry.class)})
public class WebServiceRegistryImpl
implements BindingController,
LifeCycleController,
WebServiceRegistry {
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    private Component component;
    Map<String, WebServiceInformationBean> webservices;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public synchronized Set<WebServiceInformationBean> getWebServices() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entering method : getWebServices");
        }
        if (this.webservices == null) {
            this.webservices = new HashMap<String, WebServiceInformationBean>();
            this.load();
        }
        return new HashSet<WebServiceInformationBean>(this.webservices.values());
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void load() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entering method : load");
        }
        try {
            SuperController superController = Fractal.getSuperController((Component)this.component);
            if (superController.getFcSuperComponents().length != 1) {
                this.log.warning((Object)"Can not find a super component to look at WS children");
            } else {
                Component component = superController.getFcSuperComponents()[0];
                ContentController contentController = Fractal.getContentController((Component)component);
                Component[] componentArray = contentController.getFcSubComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] objectArray;
                    Component component2 = componentArray[n2];
                    String string = Fractal.getNameController((Component)component2).getFcName();
                    Object[] objectArray2 = objectArray = component2.getFcInterfaces();
                    int n3 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?>[] classArray;
                        Object object = objectArray2[n4];
                        Class<?>[] classArray2 = classArray = object.getClass().getInterfaces();
                        int n5 = classArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Class<?> clazz = classArray2[n6];
                            boolean bl = WebServiceHelper.hasWebServiceAnnotation(clazz);
                            if (bl) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("The component " + string + " is a compliant web service"));
                                }
                                WebServiceInformationBean webServiceInformationBean = new WebServiceInformationBean();
                                webServiceInformationBean.clazz = clazz;
                                webServiceInformationBean.componentName = string;
                                webServiceInformationBean.implem = object;
                                this.webservices.put(string, webServiceInformationBean);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found " + this.webservices.size() + " in architecture"));
                }
            }
        }
        catch (Exception exception) {
            this.log.warning((Object)exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

