/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.webapp;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Servlet;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;
import org.petalslink.dsb.kernel.api.webapp.WebAppServer;
import org.petalslink.dsb.kernel.webapp.ListServlet;
import org.petalslink.dsb.kernel.webapp.ProxyManagement;
import org.petalslink.dsb.kernel.webapp.WebAppClassLoader;
import org.petalslink.dsb.webapp.api.DSBManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=WebAppServer.class)})
public class JettyWebAppServerImpl
implements BindingController,
LifeCycleController,
WebAppServer {
    private LoggerFactory loggerFactory;
    public static final String WEBAPP_NAME = "dsb-webapp";
    private Logger logger;
    private LoggingUtil log;
    @Requires(contingency=Contingency.OPTIONAL, name="dsbmanagement", signature=DSBManagement.class)
    private DSBManagement dsbManagement;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="dsbconfiguration", signature=DSBConfigurationService.class)
    private DSBConfigurationService dsbConfigurationService;
    private Server server;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void startComponent() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stopCoponent() {
        this.log.debug((Object)"Stopping...");
        this.stop();
        this.server = null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.startComponent();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycleListener(phase=Phase.START)
    public void start() throws DSBException {
        File file;
        if (this.isStarted()) {
            this.log.info((Object)"Server is already started...");
            return;
        }
        File file2 = new File(this.configurationService.getContainerConfiguration().getRootDirectoryPath(), "webapps");
        File[] fileArray = file2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getAbsolutePath().endsWith(".war");
            }
        });
        this.server = new Server(this.dsbConfigurationService.getWebAppPort());
        HashSet<String> hashSet = new HashSet<String>(fileArray.length);
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray2[n2];
            String string = file.getName();
            if (string.endsWith(".war")) {
                string = string.substring(0, string.length() - 4);
            }
            WebAppContext webAppContext = new WebAppContext();
            webAppContext.setContextPath("/" + string);
            webAppContext.setWar(file.getAbsolutePath());
            File file3 = new File(this.configurationService.getContainerConfiguration().getRootDirectoryPath(), "work");
            File file4 = new File(file3, string);
            File file5 = new File(file4, string);
            file5.mkdirs();
            webAppContext.setTempDirectory(file5);
            webAppContext.setExtractWAR(true);
            ProxyManagement proxyManagement = new ProxyManagement(this.dsbManagement);
            try {
                WebAppClassLoader webAppClassLoader = new WebAppClassLoader(proxyManagement.getClass().getClassLoader(), webAppContext, this.logger);
                webAppContext.setClassLoader((ClassLoader)((Object)webAppClassLoader));
            }
            catch (IOException iOException) {}
            webAppContext.getServletContext().setAttribute("dsbmanagement", (Object)proxyManagement);
            webAppContext.setAttribute("dsbmanagement", (Object)proxyManagement);
            contextHandlerCollection.addHandler((Handler)webAppContext);
            hashSet.add(string);
            ++n2;
        }
        file = new Context((HandlerContainer)contextHandlerCollection, "/dsb", 1);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ListServlet(hashSet));
        servletHolder.setName("DSBWebappsListServlet");
        servletHolder.setInitOrder(1);
        file.addServlet(servletHolder, "/*");
        this.server.setHandler((Handler)contextHandlerCollection);
        try {
            this.server.start();
        }
        catch (Throwable throwable) {
            this.log.warning((Object)throwable.getMessage());
        }
        this.log.info((Object)("The DSB Web application is available at http://localhost:" + this.dsbConfigurationService.getWebAppPort() + "/dsb/"));
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stopCoponent();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private boolean isStarted() {
        return this.server != null && this.server.isStarted();
    }

    @LifeCycleListener(phase=Phase.STOP)
    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                this.log.warning((Object)exception.getMessage());
            }
        }
    }

    public List<String> getWebAppNames() {
        return Arrays.asList(WEBAPP_NAME);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("dsbmanagement")) {
            if (!DSBManagement.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBManagement.class.getName());
            }
            this.dsbManagement = (DSBManagement)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("dsbconfiguration")) {
            if (!DSBConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBConfigurationService.class.getName());
            }
            this.dsbConfigurationService = (DSBConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("dsbmanagement");
        arrayList.add("configuration");
        arrayList.add("dsbconfiguration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("dsbmanagement")) {
            return this.dsbManagement;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("dsbconfiguration")) {
            return this.dsbConfigurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("dsbmanagement")) {
            this.dsbManagement = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("dsbconfiguration")) {
            this.dsbConfigurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

