/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.api.management.binder.BinderException;
import org.petalslink.dsb.kernel.api.management.binder.ServiceBinder;
import org.petalslink.dsb.kernel.api.management.binder.ServiceBinderRegistry;
import org.petalslink.dsb.kernel.api.management.binder.ServiceRegistry;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.api.RESTServiceBinder;
import org.petalslink.dsb.ws.api.ServiceEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=KernelWebService.class), @Interface(name="webservice", signature=RESTServiceBinder.class)})
public class RESTServiceBinderServiceImpl
implements BindingController,
LifeCycleController,
KernelWebService,
RESTServiceBinder {
    private Logger logger;
    private LoggingUtil log;
    private Component component;
    @Requires(name="binder-registry", signature=ServiceBinderRegistry.class)
    protected ServiceBinderRegistry serviceBinderRegistry;
    @Requires(name="service-registry", signature=ServiceRegistry.class)
    protected ServiceRegistry serviceRegistry;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServiceEndpoint bindRESTService(String string, String string2) throws DSBWebServiceException {
        if (this.serviceRegistry.getURLs("rest").contains(string)) {
            throw new DSBWebServiceException("This REST service '" + string + "' is already bound");
        }
        ServiceEndpoint serviceEndpoint = null;
        ServiceBinder serviceBinder = this.serviceBinderRegistry.getServiceBinder("rest");
        if (serviceBinder == null) throw new DSBWebServiceException("No valid service binder can be found for REST services");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("restURL", string);
        hashMap.put("ep", string2);
        try {
            List list = serviceBinder.bind(hashMap);
            if (list == null) return serviceEndpoint;
            return (ServiceEndpoint)list.get(0);
        }
        catch (BinderException binderException) {
            throw new DSBWebServiceException("Can not bind REST service", (Throwable)binderException);
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean unbindRESTService(String string) throws DSBWebServiceException {
        throw new DSBWebServiceException("Not implemented");
    }

    public Set<String> getRESTServices() throws DSBWebServiceException {
        return this.serviceRegistry.getURLs("rest");
    }

    public Component getComponent() {
        return this.component;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("binder-registry")) {
            if (!ServiceBinderRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServiceBinderRegistry.class.getName());
            }
            this.serviceBinderRegistry = (ServiceBinderRegistry)object;
            return;
        }
        if (string.equals("service-registry")) {
            if (!ServiceRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServiceRegistry.class.getName());
            }
            this.serviceRegistry = (ServiceRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("binder-registry");
        arrayList.add("service-registry");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("binder-registry")) {
            return this.serviceBinderRegistry;
        }
        if (string.equals("service-registry")) {
            return this.serviceRegistry;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("binder-registry")) {
            this.serviceBinderRegistry = null;
            return;
        }
        if (string.equals("service-registry")) {
            this.serviceRegistry = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

