/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.ws;

import java.util.ArrayList;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.api.RESTServiceBinder;
import org.petalslink.dsb.ws.api.SOAPServiceBinder;
import org.petalslink.dsb.ws.api.ServiceBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=KernelWebService.class), @Interface(name="webservice", signature=ServiceBinder.class)})
public class ServiceBinderImpl
implements BindingController,
LifeCycleController,
KernelWebService,
ServiceBinder {
    private Logger logger;
    private LoggingUtil log;
    private Component component;
    private LoggerFactory loggerFactory;
    @Requires(name="restservice-binder", signature=RESTServiceBinder.class)
    protected RESTServiceBinder restServiceBinder;
    @Requires(name="soapservice-binder", signature=RESTServiceBinder.class)
    protected SOAPServiceBinder soapServiceBinder;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean bindWebService(String string) throws DSBWebServiceException {
        this.log.warning((Object)"Deprecated, use SOAPServiceBinderServiceImpl instead");
        this.soapServiceBinder.bindWebService(string);
        return true;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public boolean bindRESTService(String string, String string2) throws DSBWebServiceException {
        this.log.warning((Object)"Deprecated, use RESTServiceBinderServiceImpl instead");
        this.restServiceBinder.bindRESTService(string, string2);
        return true;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public Set<String> getRESTServices() throws DSBWebServiceException {
        this.log.warning((Object)"Deprecated, use RESTServiceBinderServiceImpl instead");
        return this.restServiceBinder.getRESTServices();
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Set<String> getWebServices() throws DSBWebServiceException {
        this.log.warning((Object)"Deprecated, use SOAPServiceBinderServiceImpl instead");
        return this.soapServiceBinder.getWebServices();
    }

    public boolean unbindRESTService(String string) throws DSBWebServiceException {
        this.log.warning((Object)"Deprecated, use RESTServiceBinderServiceImpl instead");
        return this.restServiceBinder.unbindRESTService(string);
    }

    public boolean unbindWebService(String string) throws DSBWebServiceException {
        this.log.warning((Object)"Deprecated, use SOAPServiceBinderServiceImpl instead");
        return this.soapServiceBinder.unbindWebService(string);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("restservice-binder")) {
            if (!RESTServiceBinder.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RESTServiceBinder.class.getName());
            }
            this.restServiceBinder = (RESTServiceBinder)object;
            return;
        }
        if (string.equals("soapservice-binder")) {
            if (!SOAPServiceBinder.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SOAPServiceBinder.class.getName());
            }
            this.soapServiceBinder = (SOAPServiceBinder)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("restservice-binder");
        arrayList.add("soapservice-binder");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("restservice-binder")) {
            return this.restServiceBinder;
        }
        if (string.equals("soapservice-binder")) {
            return this.soapServiceBinder;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("restservice-binder")) {
            this.restServiceBinder = null;
            return;
        }
        if (string.equals("soapservice-binder")) {
            this.soapServiceBinder = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

