/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=DSBConfigurationService.class)})
public class DSBConfigurationServiceImpl
implements BindingController,
LifeCycleController,
DSBConfigurationService {
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private long embeddedComponentDelay = 30L;
    private List<String> embeddedComponentList;
    private long endpointsPollingPeriod = 60L;
    private long endpointsPollingDelay = 120L;
    private Map<String, List<String>> services2BindAtStartup;
    private long embeddedServicesDelay = 45L;
    private int webAppPort;
    private Map<String, String> mapping;
    private String remoteTransport;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.embeddedComponentList = new ArrayList<String>();
        this.services2BindAtStartup = new HashMap<String, List<String>>();
        this.mapping = new HashMap<String, String>(2);
        this.loadConfig();
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    protected void loadConfig() {
        Object object;
        Object object2;
        Serializable serializable;
        File file = new File(this.configurationService.getContainerConfiguration().getRootDirectoryPath(), "conf");
        File file2 = new File(file, "dsb.cfg");
        if (file2.exists() && file2.isFile()) {
            serializable = new Properties();
            try {
                String[] object32;
                ((Properties)serializable).load(new FileInputStream(file2));
                object2 = ((Properties)serializable).getProperty("embedded.component.delay");
                if (object2 != null) {
                    try {
                        this.embeddedComponentDelay = Long.parseLong((String)object2);
                    }
                    catch (Exception exception) {}
                }
                if ((object2 = ((Properties)serializable).getProperty("embedded.component.list")) != null && (object32 = ((String)(object2 = ((String)object2).trim())).split(",")) != null) {
                    object = object32;
                    int n = object32.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = object[n2];
                        if (string.trim().length() > 0) {
                            this.embeddedComponentList.add(string.trim().toLowerCase());
                        }
                        ++n2;
                    }
                }
                if ((object2 = ((Properties)serializable).getProperty("endpoints.polling.period")) != null) {
                    try {
                        this.endpointsPollingPeriod = Long.parseLong((String)object2);
                    }
                    catch (Exception exception) {}
                }
                if ((object2 = ((Properties)serializable).getProperty("endpoints.polling.delay")) != null) {
                    try {
                        this.endpointsPollingDelay = Long.parseLong((String)object2);
                    }
                    catch (Exception exception) {}
                }
                if ((object2 = ((Properties)serializable).getProperty("embedded.services.delay")) != null) {
                    try {
                        this.embeddedServicesDelay = Long.parseLong((String)object2);
                    }
                    catch (Exception exception) {}
                }
                if ((object2 = ((Properties)serializable).getProperty("webapp.port")) != null) {
                    try {
                        this.webAppPort = Integer.parseInt((String)object2);
                    }
                    catch (Exception exception) {
                        this.webAppPort = 8080;
                    }
                }
                if (this.webAppPort == 0) {
                    this.webAppPort = 8080;
                }
                for (String string : ((Properties)serializable).stringPropertyNames()) {
                    if (string == null || !string.startsWith("mapping.")) continue;
                    this.mapping.put(string.substring("mapping.".length()), ((Properties)serializable).getProperty(string));
                }
                this.remoteTransport = ((Properties)serializable).getProperty("remote.transport");
                if (this.remoteTransport != null) {
                    this.remoteTransport = this.remoteTransport.toLowerCase().trim();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        if (((File)(serializable = new File(file, "services2bind.cfg"))).exists() && ((File)serializable).isFile()) {
            object2 = new Properties();
            try {
                ((Properties)object2).load(new FileInputStream((File)serializable));
                for (Object object3 : ((Properties)object2).keySet()) {
                    String string = ((Properties)object2).getProperty(object3.toString());
                    if (string == null) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (string.indexOf(44) >= 0) {
                        object = string.split(",");
                        String[] stringArray = object;
                        int n = ((String[])object).length;
                        int n3 = 0;
                        while (n3 < n) {
                            String string2 = stringArray[n3];
                            if (string2.trim().length() > 0) {
                                arrayList.add(string2.trim());
                            }
                            ++n3;
                        }
                    } else if (string.trim().length() > 0) {
                        arrayList.add(string.trim());
                    }
                    object = object3.toString();
                    if (((String)object).indexOf(46) > 0) {
                        object = ((String)object).substring(0, ((String)object).indexOf(46));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Adding Service to bind '" + (String)object + " : " + arrayList + "'"));
                    }
                    if (this.services2BindAtStartup.get(object) == null) {
                        this.services2BindAtStartup.put((String)object, new ArrayList());
                    }
                    for (String string2 : arrayList) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("The service '" + string2 + "' is defined to be bound to the Service Bus"));
                        }
                        this.services2BindAtStartup.get(object).add(string2);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public long getEmbeddedComponentDelay() {
        return this.embeddedComponentDelay;
    }

    public long getEmbeddedServicesDelay() {
        return this.embeddedServicesDelay;
    }

    public List<String> getEmbeddedComponentList() {
        return this.embeddedComponentList;
    }

    public long getEndpointsPollingPeriod() {
        return this.endpointsPollingPeriod;
    }

    public long getEndpointsPollingDelay() {
        return this.endpointsPollingDelay;
    }

    public Map<String, List<String>> getServices2BindAtStartup() {
        return this.services2BindAtStartup;
    }

    public int getWebAppPort() {
        return this.webAppPort;
    }

    public Map<String, String> getProtocolToComponentMapping() {
        return this.mapping;
    }

    public String getRemoteTransport() {
        return this.remoteTransport;
    }

    public int getWSTransportPort() {
        return 9998;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String getFederationURL() {
        this.log.warning((Object)"Deprecated, use the FederationConfigurationService instead!");
        return null;
    }

    public boolean isFederationAware() {
        this.log.warning((Object)"Deprecated, use the FederationConfigurationService instead!");
        return false;
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public String getWSKernelBaseURL() {
        StringBuffer stringBuffer = new StringBuffer("http://");
        stringBuffer.append(this.configurationService.getContainerConfiguration().getHost());
        stringBuffer.append(":");
        stringBuffer.append(this.configurationService.getContainerConfiguration().getWebservicePort());
        stringBuffer.append("/");
        String string = this.configurationService.getContainerConfiguration().getWebservicePrefix();
        string = string == null ? "petals/ws" : string.trim();
        stringBuffer.append(string);
        stringBuffer.append('/');
        return stringBuffer.toString();
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

