/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.cxf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.petalslink.dsb.kernel.cxf.DSBConduitOutputStream;

public class DSBConduit
extends AbstractConduit {
    private static final Logger LOG = LogUtils.getL7dLogger(DSBConduit.class);
    private Bus bus;

    public DSBConduit(EndpointReferenceType endpointReferenceType) {
        this(null, endpointReferenceType);
    }

    public DSBConduit(Bus bus, EndpointReferenceType endpointReferenceType) {
        super(endpointReferenceType);
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void prepare(Message message) throws IOException {
        this.getLogger().log(Level.FINE, "DSBConduit send message");
        message.setContent(OutputStream.class, (Object)new DSBConduitOutputStream(message, this.target, this));
    }
}

