/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.cxf;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.kernel.cxf.DSBConduit;
import org.petalslink.dsb.kernel.io.Constants;
import org.petalslink.dsb.kernel.io.client.ClientFactoryRegistry;
import org.petalslink.dsb.kernel.service.EndpointHelper;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.ClientFactory;
import org.petalslink.dsb.xmlutils.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DSBConduitOutputStream
extends CachedOutputStream {
    private static final Logger LOG = LogUtils.getL7dLogger(DSBConduitOutputStream.class);
    private Message message;
    private boolean isOneWay;
    private DSBConduit conduit;
    private EndpointReferenceType target;

    public DSBConduitOutputStream(Message message, EndpointReferenceType endpointReferenceType, DSBConduit dSBConduit) {
        this.message = message;
        this.conduit = dSBConduit;
        this.target = endpointReferenceType;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        this.isOneWay = this.message.getExchange().isOneWay();
        this.sendOutputMessage();
        if (this.target != null) {
            this.target.getClass();
        }
    }

    private void sendOutputMessage() throws IOException {
        try {
            Member member = (Member)this.message.get((Object)Method.class.getName());
            Class<?> clazz = member.getDeclaringClass();
            Exchange exchange = this.message.getExchange();
            BindingOperationInfo bindingOperationInfo = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            WebService webService = clazz.getAnnotation(WebService.class);
            assert (webService != null);
            QName qName = new QName(webService.targetNamespace(), webService.name());
            QName qName2 = null;
            qName2 = this.target != null ? EndpointReferenceUtils.getServiceName((EndpointReferenceType)this.target, (Bus)((Bus)this.message.getExchange().get(Bus.class))) : ((Service)this.message.getExchange().get(Service.class)).getName();
            QName qName3 = qName2;
            String string = EndpointHelper.getInstance().getEndpoint(this.message.get((Object)Message.ENDPOINT_ADDRESS).toString());
            Document document = XMLHelper.createDocument((Source)new StreamSource(this.getInputStream()), (boolean)true);
            org.petalslink.dsb.service.client.MessageImpl messageImpl = new org.petalslink.dsb.service.client.MessageImpl();
            messageImpl.setService(qName3);
            messageImpl.setInterface(qName);
            messageImpl.setEndpoint(string);
            messageImpl.setOperation(bindingOperationInfo.getName());
            messageImpl.setPayload(document);
            messageImpl.getProperties().put(Constants.MESSAGE_TYPE, "dsb_invoke");
            messageImpl.getProperties().put(Message.ENDPOINT_ADDRESS, this.message.get((Object)Message.ENDPOINT_ADDRESS) != null ? this.message.get((Object)Message.ENDPOINT_ADDRESS).toString() : null);
            messageImpl.getProperties().put(Constants.SERVICE_NAME, qName2.toString());
            messageImpl.getProperties().put(Constants.ENDPOINT_NAME, string.toString());
            messageImpl.getProperties().put(Constants.ITF_NAME, qName.toString());
            messageImpl.getProperties().put("DSBCLIENT.CLEANENDPOINT", Boolean.TRUE.toString());
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Sending the message : " + com.ebmwebsourcing.easycommons.xml.XMLHelper.createStringFromDOMDocument((Node)document));
            }
            ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
            serviceEndpoint.setEndpointName(string);
            serviceEndpoint.setServiceName(qName2);
            serviceEndpoint.setInterfaces(new QName[]{qName});
            ClientFactory clientFactory = ClientFactoryRegistry.getFactory();
            if (clientFactory == null) {
                throw new IOException("Can not find any client factory in the kernel");
            }
            Client client = clientFactory.getClient(serviceEndpoint);
            if (!this.isOneWay) {
                org.petalslink.dsb.service.client.Message message = client.sendReceive((org.petalslink.dsb.service.client.Message)messageImpl);
                MessageImpl messageImpl2 = new MessageImpl();
                messageImpl2.setExchange(exchange);
                if (LOG.isLoggable(Level.INFO)) {
                    if (message.getPayload() != null) {
                        LOG.info("RESPONSE from service : " + com.ebmwebsourcing.easycommons.xml.XMLHelper.createStringFromDOMDocument((Node)message.getPayload()));
                    } else {
                        LOG.info("RESPONSE from service is empty and should not (InOut message)");
                    }
                }
                InputStream inputStream = null;
                if (message.getPayload() != null) {
                    inputStream = XMLHelper.getInputStream((Document)message.getPayload());
                }
                if (inputStream == null) {
                    throw new IOException(new org.apache.cxf.common.i18n.Message("UNABLE.RETRIEVE.MESSAGE", LOG, new Object[0]).toString());
                }
                messageImpl2.setContent(InputStream.class, (Object)inputStream);
                messageImpl2.put(org.petalslink.dsb.service.client.Message.class, (Object)message);
                this.conduit.getMessageObserver().onMessage((Message)messageImpl2);
            } else {
                client.fireAndForget((org.petalslink.dsb.service.client.Message)messageImpl);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    protected void onWrite() throws IOException {
    }
}

