/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.cxf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.AbstractObservable;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.petalslink.dsb.kernel.cxf.DSBDestinationOutputStream;
import org.petalslink.dsb.kernel.io.server.DSBServiceServer;
import org.petalslink.dsb.kernel.io.server.DSBServiceServerFactory;
import org.petalslink.dsb.kernel.io.server.ServerFactoryRegistry;
import org.petalslink.dsb.service.client.MessageListener;
import org.petalslink.dsb.xmlutils.XMLHelper;
import org.w3c.dom.Document;

public class DSBDestination
extends AbstractDestination
implements MessageListener {
    private static final Logger LOG = LogUtils.getL7dLogger(DSBDestination.class);
    public static final String CORRELATION = "DSB-CORRELATION";
    private DSBServiceServer server;
    private Map<String, CountDownLatch> latches = new ConcurrentHashMap<String, CountDownLatch>();
    private Map<String, org.petalslink.dsb.service.client.Message> outMessages = new ConcurrentHashMap<String, org.petalslink.dsb.service.client.Message>();
    private ExecutorService executor;
    private MessageListener responseListener = new ResponseListener();

    public DSBDestination(EndpointInfo endpointInfo) {
        super(AbstractObservable.getTargetReference((EndpointInfo)endpointInfo, null), endpointInfo);
        this.executor = Executors.newFixedThreadPool(10);
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message message) {
        return new BackChannelConduit(EndpointReferenceUtils.getAnonymousEndpointReference(), message);
    }

    public void shutdown() {
        this.deactivate();
    }

    public void deactivate() {
        this.server.stop();
        this.executor.shutdownNow();
    }

    public void activate() {
        if (this.server == null) {
            DSBServiceServerFactory dSBServiceServerFactory = ServerFactoryRegistry.getFactory();
            if (dSBServiceServerFactory == null) {
                throw new RuntimeException("Can not find any factory for server");
            }
            this.server = dSBServiceServerFactory.getServiceServer();
        }
        this.server.setListener(this);
        this.server.start();
    }

    public org.petalslink.dsb.service.client.Message onMessage(org.petalslink.dsb.service.client.Message message) {
        org.petalslink.dsb.service.client.Message message2 = null;
        try {
            final MessageImpl messageImpl = new MessageImpl();
            messageImpl.put(org.petalslink.dsb.service.client.Message.class, (Object)message);
            Document document = message.getPayload();
            InputStream inputStream = XMLHelper.getInputStream((Document)document);
            if (document != null) {
                messageImpl.setContent(InputStream.class, (Object)inputStream);
            }
            messageImpl.setDestination((Destination)this);
            String string = (String)message.getProperties().get(CORRELATION);
            if (string == null) {
                string = UUID.randomUUID().toString();
                message.getProperties().put(CORRELATION, string);
            }
            messageImpl.put(CORRELATION, (Object)string);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.latches.put(string, countDownLatch);
            this.executor.submit(new Runnable(){

                public void run() {
                    ((AbstractObservable)DSBDestination.this).incomingObserver.onMessage((Message)messageImpl);
                }
            });
            countDownLatch.await(30L, TimeUnit.SECONDS);
            LOG.fine("We have a response, send it back to the client");
            message2 = this.outMessages.remove(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Timeout or exception while invokiing the service...");
        }
        return message2;
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected Message inMessage;
        protected DSBDestination destination;

        BackChannelConduit(EndpointReferenceType endpointReferenceType, Message message) {
            super(endpointReferenceType);
            this.inMessage = message;
        }

        public void setMessageObserver(MessageObserver messageObserver) {
        }

        public void prepare(Message message) throws IOException {
            message.put(MessageExchange.class, (Object)((MessageExchange)this.inMessage.get(MessageExchange.class)));
            message.setContent(OutputStream.class, (Object)new DSBDestinationOutputStream(this.inMessage, message, DSBDestination.this.responseListener));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }

    private class ResponseListener
    implements MessageListener {
        private ResponseListener() {
        }

        public org.petalslink.dsb.service.client.Message onMessage(org.petalslink.dsb.service.client.Message message) {
            LOG.fine("Got out message on response listener");
            String string = (String)message.getProperties().get(DSBDestination.CORRELATION);
            if (string != null && DSBDestination.this.latches.get(string) != null) {
                DSBDestination.this.outMessages.put(string, message);
                ((CountDownLatch)DSBDestination.this.latches.get(string)).countDown();
            }
            return null;
        }
    }
}

