/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.server.FractalHelper;
import org.ow2.petals.kernel.ws.api.InformationService;
import org.ow2.petals.kernel.ws.api.InstallationService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.webapp.api.DSBManagement;
import org.petalslink.dsb.ws.api.DSBInformationService;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.api.ServiceInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=DSBManagement.class)})
public class DSBManagementImpl
implements BindingController,
LifeCycleController,
DSBManagement {
    private LoggerFactory loggerFactory;
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="information", signature=InformationService.class)
    private InformationService informationService;
    @Requires(name="serviceinfo", signature=ServiceInformation.class)
    private ServiceInformation serviceInformation;
    @Requires(name="dsbinformation", signature=InstallationService.class)
    private DSBInformationService dsbInformationService;
    private Component component;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public String getFcState() {
        return null;
    }

    public String getContainerInfo() {
        try {
            return this.informationService.getVersion();
        }
        catch (PEtALSWebServiceException pEtALSWebServiceException) {
            return "";
        }
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Set<String> getContainerServices() {
        try {
            return new HashSet<String>(this.dsbInformationService.getWebServices());
        }
        catch (DSBWebServiceException dSBWebServiceException) {
            return null;
        }
    }

    public Set<String> getWebServices() {
        return new HashSet<String>(this.serviceInformation.getExposedWebServices());
    }

    public Set<String> getRESTServices() {
        return new HashSet<String>(this.serviceInformation.getExposedRESTServices());
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public <T> T get(Class<T> clazz, String string, String string2) {
        T t = null;
        try {
            SuperController superController = Fractal.getSuperController((Component)this.component);
            Component component = superController.getFcSuperComponents()[0];
            ContentController contentController = Fractal.getContentController((Component)component);
            Component component2 = FractalHelper.getRecursiveComponentByName((ContentController)contentController, (String)string);
            if (component2 != null) {
                String string3 = string2 != null ? string2 : "service";
                Object object = component2.getFcInterface(string3);
                if (object != null) {
                    try {
                        t = clazz.cast(object);
                    }
                    catch (ClassCastException classCastException) {
                        classCastException.printStackTrace();
                    }
                }
            } else {
                System.out.println("No such component : " + string);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            noSuchInterfaceException.printStackTrace();
        }
        return t;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("information")) {
            if (!InformationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + InformationService.class.getName());
            }
            this.informationService = (InformationService)object;
            return;
        }
        if (string.equals("serviceinfo")) {
            if (!ServiceInformation.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServiceInformation.class.getName());
            }
            this.serviceInformation = (ServiceInformation)object;
            return;
        }
        if (string.equals("dsbinformation")) {
            if (!DSBInformationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBInformationService.class.getName());
            }
            this.dsbInformationService = (DSBInformationService)object;
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("information");
        arrayList.add("serviceinfo");
        arrayList.add("dsbinformation");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("information")) {
            return this.informationService;
        }
        if (string.equals("serviceinfo")) {
            return this.serviceInformation;
        }
        if (string.equals("dsbinformation")) {
            return this.dsbInformationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("information")) {
            this.informationService = null;
            return;
        }
        if (string.equals("serviceinfo")) {
            this.serviceInformation = null;
            return;
        }
        if (string.equals("dsbinformation")) {
            this.dsbInformationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

