/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.binder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;
import org.petalslink.dsb.kernel.api.management.binder.BinderException;
import org.petalslink.dsb.kernel.api.management.binder.EmbeddedServiceBinder;
import org.petalslink.dsb.kernel.api.management.binder.ServiceBinder;
import org.petalslink.dsb.kernel.api.management.binder.ServiceBinderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=EmbeddedServiceBinder.class)})
public class EmbeddedServiceBinderImpl
implements BindingController,
LifeCycleController,
EmbeddedServiceBinder {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    @Requires(name="dsb-configuration", signature=DSBConfigurationService.class)
    private DSBConfigurationService configurationService;
    @Requires(name="binder-registry", signature=ServiceBinderRegistry.class)
    private ServiceBinderRegistry serviceBinderRegistry;
    private Map<String, List<String>> unbound;
    private boolean firstCall;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.firstCall = true;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    @LifeCycleListener(phase=Phase.START, priority=900)
    public synchronized void bindAll() {
        Map<String, List<String>> map = this.getServicesToBind();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (map == null || map.size() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No embedded service to bind");
            }
            return;
        }
        this.log.info((Object)"Let's bind services which have been defined from configuration file");
        for (String string : map.keySet()) {
            ServiceBinder serviceBinder;
            List<String> list = map.get(string);
            if (list == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("No service to bind for protocol '" + string + "'"));
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Getting service binder for '" + string + "'"));
            }
            if ((serviceBinder = this.serviceBinderRegistry.getServiceBinder(string)) != null) {
                for (String string2 : list) {
                    if (string2 == null || string2.trim().length() <= 0) continue;
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    hashMap2.put("wsdl", string2.trim());
                    hashMap2.put("url", string2.trim());
                    hashMap2.put("restURL", string2.trim());
                    try {
                        serviceBinder.bind(hashMap2);
                    }
                    catch (BinderException binderException) {
                        this.log.warning((Object)binderException.getMessage());
                        if (hashMap.get(string) == null) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            arrayList.add(string2);
                            hashMap.put(string, arrayList);
                            continue;
                        }
                        ((List)hashMap.get(string)).add(string2);
                    }
                }
                continue;
            }
            this.log.warning((Object)("No service binder has been found for protocol '" + string + "'"));
        }
        this.unbound = hashMap;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Embedded services which have not be bound are : " + this.unbound));
        }
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Map<String, List<String>> getServicesToBind() {
        Map map = null;
        map = this.firstCall ? this.configurationService.getServices2BindAtStartup() : this.unbound;
        this.firstCall = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Services to bind = " + map));
        }
        return map;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("dsb-configuration")) {
            if (!DSBConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBConfigurationService.class.getName());
            }
            this.configurationService = (DSBConfigurationService)object;
            return;
        }
        if (string.equals("binder-registry")) {
            if (!ServiceBinderRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServiceBinderRegistry.class.getName());
            }
            this.serviceBinderRegistry = (ServiceBinderRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("dsb-configuration");
        arrayList.add("binder-registry");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("dsb-configuration")) {
            return this.configurationService;
        }
        if (string.equals("binder-registry")) {
            return this.serviceBinderRegistry;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("dsb-configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("binder-registry")) {
            this.serviceBinderRegistry = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

