/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.binder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.Consumes;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;
import org.petalslink.dsb.kernel.api.management.binder.BinderException;
import org.petalslink.dsb.kernel.api.management.binder.NewServiceExposer;
import org.petalslink.dsb.kernel.api.management.binder.ServiceExposer;
import org.petalslink.dsb.kernel.api.management.binder.ServiceExposerRegistry;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=NewServiceExposer.class)})
public class NewServiceExposerImpl
implements BindingController,
LifeCycleController,
NewServiceExposer {
    private LoggerFactory loggerFactory;
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="registry", signature=EndpointRegistry.class)
    protected EndpointRegistry endpointRegistry;
    @Requires(name="exposer-registry", signature=ServiceExposerRegistry.class)
    protected ServiceExposerRegistry serviceExposerRegistry;
    @Requires(name="adminService", signature=AdminService.class)
    private AdminService adminService;
    @Requires(name="dsbconfiguration", signature=DSBConfigurationService.class)
    protected DSBConfigurationService configuration;
    private Map<String, org.ow2.petals.kernel.api.service.ServiceEndpoint> exposedEndpoints;
    private AtomicLong nbCalls = new AtomicLong(0L);
    private final Object object = new Object();

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.exposedEndpoints = new HashMap<String, org.ow2.petals.kernel.api.service.ServiceEndpoint>();
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expose() {
        long l = this.nbCalls.incrementAndGet();
        this.log.debug((Object)"Got a #expose call, waiting previous call to complete...");
        this.log.debug((Object)("Waiting previous expose to complete (current call is '" + l + "')..."));
        Object object = this.object;
        synchronized (object) {
            this.log.debug((Object)("Seems that all previous tasks are complete (current call is '" + l + "'), let's go..."));
            this.log.debug((Object)("Let's expose new endpoints (current call is '" + l + "')!"));
            try {
                List list = this.endpointRegistry.getEndpoints();
                for (ServiceEndpoint serviceEndpoint : list) {
                    if (this.isNew((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint) && this.isPlatformService((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint)) {
                        this.bind((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint);
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Endpoint " + serviceEndpoint.getEndpointName() + " is not new or is not a platform service"));
                }
            }
            catch (RegistryException registryException) {
                this.log.warning((Object)registryException.getMessage());
            }
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected boolean isPlatformService(org.ow2.petals.kernel.api.service.ServiceEndpoint serviceEndpoint) {
        return true;
    }

    public boolean isNew(org.ow2.petals.kernel.api.service.ServiceEndpoint serviceEndpoint) {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = bl = this.exposedEndpoints.get(this.getKey(serviceEndpoint)) != null;
        if (!bl) {
            String string = this.getProtocolName(serviceEndpoint);
            String string2 = (String)this.configuration.getProtocolToComponentMapping().get(string);
            Map map = this.adminService.getServiceAssemblies();
            for (ServiceAssemblyLifeCycle serviceAssemblyLifeCycle : map.values()) {
                List list = serviceAssemblyLifeCycle.getServiceUnitLifeCycles();
                Iterator iterator = list.iterator();
                boolean bl4 = false;
                while (iterator.hasNext() && !bl4) {
                    ServiceUnitLifeCycle serviceUnitLifeCycle = (ServiceUnitLifeCycle)iterator.next();
                    Jbi jbi = serviceUnitLifeCycle.getServiceUnitDescriptor();
                    List list2 = jbi.getServices().getConsumes();
                    if (list2 == null || list2.size() <= 0) continue;
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext() && !bl4) {
                        Consumes consumes = (Consumes)iterator2.next();
                        boolean bl5 = bl4 = consumes.getEndpointName().equals(serviceEndpoint.getEndpointName()) && consumes.getServiceName().equals(serviceEndpoint.getServiceName()) && serviceUnitLifeCycle.getTargetComponentName().equals(string2);
                    }
                }
                if (!bl4) continue;
                this.log.debug((Object)String.format("Service endpoint %s has been found in the container, so this endpoint is not new", this.getKey(serviceEndpoint)));
                this.exposedEndpoints.put(this.getKey(serviceEndpoint), serviceEndpoint);
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private String getKey(org.ow2.petals.kernel.api.service.ServiceEndpoint serviceEndpoint) {
        StringBuffer stringBuffer = new StringBuffer("EP:");
        stringBuffer.append(serviceEndpoint.toString());
        stringBuffer.append(serviceEndpoint.getLocation().toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Service endpoint key is : " + stringBuffer.toString()));
        }
        return stringBuffer.toString();
    }

    public void bind(org.ow2.petals.kernel.api.service.ServiceEndpoint serviceEndpoint) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Let's bind the service endpoint " + serviceEndpoint));
        }
        if (serviceEndpoint == null) {
            this.log.warning((Object)"Service endpoint is null and will not be exposed!");
            return;
        }
        String string = "soap";
        if (serviceEndpoint.getEndpointName() != null && serviceEndpoint.getEndpointName().startsWith("RestPlatform")) {
            string = "rest";
        }
        if (string == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This endpoint '" + serviceEndpoint.getEndpointName() + "' can not be exposed since it has not be recognized as platform service"));
            }
            return;
        }
        ServiceExposer serviceExposer = this.serviceExposerRegistry.getServiceExposer(string);
        if (serviceExposer != null) {
            try {
                org.petalslink.dsb.ws.api.ServiceEndpoint serviceEndpoint2 = new org.petalslink.dsb.ws.api.ServiceEndpoint();
                serviceEndpoint2.setEndpoint(serviceEndpoint.getEndpointName());
                if (serviceEndpoint.getInterfacesName() != null && serviceEndpoint.getInterfacesName().size() > 0) {
                    serviceEndpoint2.setItf((QName)serviceEndpoint.getInterfacesName().get(0));
                }
                serviceEndpoint2.setService(serviceEndpoint.getServiceName());
                serviceExposer.expose(serviceEndpoint2);
                this.exposedEndpoints.put(this.getKey(serviceEndpoint), serviceEndpoint);
            }
            catch (BinderException binderException) {
                this.log.warning((Object)("Problem while binding : " + binderException.getMessage()));
                if (this.log.isDebugEnabled()) {
                    this.log.warning((Object)"Stack cause", (Throwable)binderException);
                }
            }
        } else {
            this.log.warning((Object)("No service exposer has been found for protocol : " + string));
        }
    }

    public String getProtocolName(org.ow2.petals.kernel.api.service.ServiceEndpoint serviceEndpoint) {
        String string = "soap";
        if (serviceEndpoint.getEndpointName() != null && serviceEndpoint.getEndpointName().startsWith("RestPlatform")) {
            string = "rest";
        }
        return string;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("registry")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("exposer-registry")) {
            if (!ServiceExposerRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServiceExposerRegistry.class.getName());
            }
            this.serviceExposerRegistry = (ServiceExposerRegistry)object;
            return;
        }
        if (string.equals("adminService")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        if (string.equals("dsbconfiguration")) {
            if (!DSBConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBConfigurationService.class.getName());
            }
            this.configuration = (DSBConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("registry");
        arrayList.add("exposer-registry");
        arrayList.add("adminService");
        arrayList.add("dsbconfiguration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("registry")) {
            return this.endpointRegistry;
        }
        if (string.equals("exposer-registry")) {
            return this.serviceExposerRegistry;
        }
        if (string.equals("adminService")) {
            return this.adminService;
        }
        if (string.equals("dsbconfiguration")) {
            return this.configuration;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("registry")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("exposer-registry")) {
            this.serviceExposerRegistry = null;
            return;
        }
        if (string.equals("adminService")) {
            this.adminService = null;
            return;
        }
        if (string.equals("dsbconfiguration")) {
            this.configuration = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

