/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.binder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.deployment.AtomicDeploymentService;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationException;
import org.ow2.petals.tools.generator.jbi.ws2jbi.Constants;
import org.ow2.petals.tools.generator.jbi2ws.Jbi2WS;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.jbi.JBIFileHelper;
import org.petalslink.dsb.kernel.api.management.binder.BinderChecker;
import org.petalslink.dsb.kernel.api.management.binder.BinderException;
import org.petalslink.dsb.kernel.api.management.binder.ServiceExposer;
import org.petalslink.dsb.ws.api.ServiceEndpoint;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ServiceExposer.class)})
public class SOAPServiceExposerImpl
implements BindingController,
LifeCycleController,
ServiceExposer {
    private LoggerFactory loggerFactory;
    private static final String WORK_DIR = "work";
    @Requires(name="atomic-deployment", signature=AtomicDeploymentService.class)
    private AtomicDeploymentService deploymentService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="binder-checker", signature=BinderChecker.class)
    private BinderChecker binderChecker;
    private File workPath;
    private Logger logger;
    private LoggingUtil log;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.workPath = new File(this.configurationService.getContainerConfiguration().getWorkDirectoryPath(), WORK_DIR);
        if (!this.workPath.exists()) {
            this.workPath.mkdirs();
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void expose(ServiceEndpoint serviceEndpoint) throws BinderException {
        boolean bl;
        if (!this.binderChecker.canExposeOnProtocol(this.getProtocol())) {
            throw new BinderException("No component found to expose SOAP service");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Trying to expose service wich is defined as EP = %s, SRV=%s and ITF = %s", serviceEndpoint.getEndpoint(), serviceEndpoint.getService().toString(), serviceEndpoint.getItf().toString()));
        }
        File file = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Constants.OUTPUT_DIR, this.workPath.getAbsolutePath());
        QName qName = serviceEndpoint.getItf();
        QName qName2 = serviceEndpoint.getService();
        hashMap.put("component.version", "4.0");
        String string = serviceEndpoint.getEndpoint();
        if (string == null && qName != null) {
            string = qName.getLocalPart();
        }
        if (string == null) {
            throw new BinderException("Can not find a valid name to create service name from given endpoint and interface");
        }
        if (string.startsWith("SoapPlatform")) {
            string = string.substring("SoapPlatform".length(), string.length());
        }
        hashMap.put("soap.endpointaddress", string);
        Jbi2WS jbi2WS = new Jbi2WS(serviceEndpoint.getEndpoint(), qName2, qName, hashMap);
        try {
            file = jbi2WS.generate();
        }
        catch (JBIGenerationException jBIGenerationException) {
            if (this.log.isDebugEnabled()) {
                jBIGenerationException.printStackTrace();
            }
            throw new BinderException(jBIGenerationException.getMessage());
        }
        Jbi jbi = JBIFileHelper.readDescriptor((File)file);
        if (jbi == null) {
            throw new BinderException("Can not get the JBI descriptor...");
        }
        String string2 = jbi.getServiceAssembly().getIdentification().getName();
        if (string2 == null) {
            throw new BinderException("Can not get the JBI service assembly name");
        }
        try {
            bl = this.deploymentService.deploy(file.toURI().toURL());
            if (!bl) {
                this.log.warning((Object)("Failed to deploy the Service Assembly located at '" + file.toURI().toURL() + "'"));
                throw new PEtALSWebServiceException("Deployment failure");
            }
            this.log.info((Object)("Service assembly '" + string2 + "' has been deployed"));
        }
        catch (Exception exception) {
            throw new BinderException(exception.getMessage());
        }
        try {
            bl = this.deploymentService.start(string2);
            if (!bl) {
                this.log.warning((Object)("Failed to start the Service Assembly '" + string2 + "'"));
                throw new PEtALSWebServiceException("Start failure");
            }
            this.log.info((Object)("Service assembly '" + string2 + "' has been deployed"));
        }
        catch (Exception exception) {
            throw new BinderException(exception.getMessage());
        }
        if (file != null) {
            file.delete();
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String getProtocol() {
        return "soap";
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("atomic-deployment")) {
            if (!AtomicDeploymentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AtomicDeploymentService.class.getName());
            }
            this.deploymentService = (AtomicDeploymentService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("binder-checker")) {
            if (!BinderChecker.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + BinderChecker.class.getName());
            }
            this.binderChecker = (BinderChecker)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("atomic-deployment");
        arrayList.add("configuration");
        arrayList.add("binder-checker");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("atomic-deployment")) {
            return this.deploymentService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("binder-checker")) {
            return this.binderChecker;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("atomic-deployment")) {
            this.deploymentService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("binder-checker")) {
            this.binderChecker = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

