/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.protocol;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.management.protocol.ProtocolService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ProtocolService.class)})
public class FileProtocolServiceImpl
implements BindingController,
LifeCycleController,
ProtocolService {
    private static final String FILE_NAME = "protocol.properties";
    private LoggerFactory loggerFactory;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private Logger logger;
    private LoggingUtil log;
    private Properties props;
    private File protocols;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        File file = new File(this.configurationService.getContainerConfiguration().getRootDirectoryPath(), "conf");
        this.protocols = new File(file, FILE_NAME);
        if (!this.protocols.exists()) {
            try {
                this.protocols.createNewFile();
            }
            catch (IOException iOException) {}
        }
        this.props = new Properties();
        try {
            this.props.load(new FileInputStream(this.protocols));
        }
        catch (IOException iOException) {
            this.log.warning((Object)("Can not load protocols : " + iOException.getMessage()));
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
        try {
            this.props.store(new FileOutputStream(this.protocols), "Saved on " + new Date());
        }
        catch (IOException iOException) {
            this.log.warning((Object)("Can not save protocols : " + iOException.getMessage()));
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void addProtocol(String string) {
        if (this.props.get(string) == null) {
            this.props.put(string, string);
        }
    }

    public List<String> getProtocols() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.props.keySet()) {
            arrayList.add(object.toString());
        }
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

