/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.descriptor.original.generated.LinkType;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.endpoint.EndpointOrderer;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.jbi.Adapter;
import org.petalslink.dsb.kernel.api.PetalsService;
import org.petalslink.dsb.kernel.api.messaging.EndpointSearchEngine;
import org.petalslink.dsb.kernel.api.messaging.SearchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointSearchEngineImpl
implements PetalsService,
EndpointSearchEngine {
    private final org.ow2.petals.util.oldies.LoggingUtil log;
    public static final List<Object> DEFAULT_STRATEGY_PARAMETERS = Arrays.asList("highest", new Float(3.0f), new Float(2.0f), new Float(1.0f));
    private static List<Object> defaultStrategyParameters;
    private EndpointOrderer endpointOrderer;
    private Random random;
    private TopologyService topologyService;
    private ConfigurationService configurationService;
    private EndpointRegistry endpointRegistry;

    public EndpointSearchEngineImpl(org.ow2.petals.util.oldies.LoggingUtil loggingUtil) {
        this.log = loggingUtil;
    }

    public void init() throws Exception {
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        try {
            defaultStrategyParameters = EndpointSearchEngineImpl.analyseStrategy(containerConfiguration.getRouterStrategy());
        }
        catch (RoutingException routingException) {
            defaultStrategyParameters = DEFAULT_STRATEGY_PARAMETERS;
        }
        Logger logger = Logger.getLogger(this.log.getName());
        LoggingUtil loggingUtil = new LoggingUtil(logger);
        this.endpointOrderer = new EndpointOrderer(loggingUtil, containerConfiguration, this.topologyService);
        this.random = new Random();
    }

    public void setup() throws Exception {
    }

    public void shutdown() throws Exception {
    }

    public org.petalslink.dsb.api.ServiceEndpoint getTargetedEndpointFromGivenEndpoint(org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint, String string) throws SearchException {
        this.log.call();
        org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint2 = null;
        if (serviceEndpoint.getType().equals(ServiceEndpoint.EndpointType.INTERNAL.toString())) {
            if (LinkType.SOFT.value().equals(string)) {
                throw new SearchException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' is not a SOFT link");
            }
            serviceEndpoint2 = serviceEndpoint;
        } else if (serviceEndpoint.getType().equals(ServiceEndpoint.EndpointType.LINKED.toString())) {
            if (LinkType.HARD.value().equals(string)) {
                throw new SearchException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' is not an HARD link");
            }
            try {
                ServiceEndpoint serviceEndpoint3 = this.endpointRegistry.getEndpoint(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
                serviceEndpoint2 = Adapter.createDSBServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint3);
            }
            catch (RegistryException registryException) {
                throw new SearchException((Throwable)registryException);
            }
        } else if (serviceEndpoint.getType() == ServiceEndpoint.EndpointType.EXTERNAL.toString()) {
            serviceEndpoint2 = this.findEndpointInRegistry(serviceEndpoint);
        }
        return serviceEndpoint2;
    }

    private org.petalslink.dsb.api.ServiceEndpoint findEndpointInRegistry(org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint) throws SearchException {
        this.log.call();
        org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint2 = null;
        try {
            ServiceEndpoint serviceEndpoint3 = this.endpointRegistry.getEndpoint(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
            serviceEndpoint2 = Adapter.createDSBServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint3);
        }
        catch (RegistryException registryException) {
            throw new SearchException(registryException.getMessage());
        }
        if (serviceEndpoint2 == null) {
            throw new SearchException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' does not match a registered endpoint");
        }
        return serviceEndpoint2;
    }

    public List<org.petalslink.dsb.api.ServiceEndpoint> getTargetedEndpointFromGivenServiceName(QName qName, String string, String string2) throws SearchException {
        List<Object> list;
        Object object;
        this.log.call();
        List<ServiceEndpoint> list2 = null;
        try {
            list2 = this.getEnabledEndpoints(kindSearch.SERVICE_SEARCH, qName, string2);
        }
        catch (RegistryException registryException) {
            throw new SearchException((Throwable)registryException);
        }
        try {
            object = string;
            if (object == null) {
                object = this.configurationService.getContainerConfiguration().getRouterStrategy();
            }
            list = EndpointSearchEngineImpl.analyseStrategy((String)object);
        }
        catch (RoutingException routingException) {
            throw new SearchException(routingException.getMessage());
        }
        object = null;
        if (list2.size() == 1) {
            object = new ArrayList(1);
            object.add(list2.get(0));
        } else if (list2.size() > 1) {
            try {
                object = this.endpointOrderer.orderEndpoints(list2, list);
            }
            catch (RoutingException routingException) {
                throw new SearchException((Throwable)routingException);
            }
        }
        if (object == null || object.size() == 0) {
            throw new SearchException("No endpoint found matching the target service '" + qName + "'");
        }
        ArrayList<org.petalslink.dsb.api.ServiceEndpoint> arrayList = new ArrayList<org.petalslink.dsb.api.ServiceEndpoint>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ServiceEndpoint serviceEndpoint = (ServiceEndpoint)iterator.next();
            arrayList.add(Adapter.createDSBServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint));
        }
        return arrayList;
    }

    public List<org.petalslink.dsb.api.ServiceEndpoint> getTargetedEndpointFromGivenInterfaceName(QName qName, String string, String string2) throws SearchException {
        List<Object> list;
        Object object;
        this.log.call();
        List<ServiceEndpoint> list2 = null;
        try {
            list2 = this.getEnabledEndpoints(kindSearch.INTERFACE_SEARCH, qName, string2);
        }
        catch (RegistryException registryException) {
            throw new SearchException((Throwable)registryException);
        }
        try {
            object = string;
            if (object == null) {
                object = this.configurationService.getContainerConfiguration().getRouterStrategy();
            }
            list = EndpointSearchEngineImpl.analyseStrategy(string);
        }
        catch (RoutingException routingException) {
            throw new SearchException(routingException.getMessage());
        }
        object = null;
        if (list2.size() == 1) {
            object = new ArrayList(1);
            object.add(list2.get(0));
        } else if (list2.size() > 1) {
            try {
                object = this.endpointOrderer.orderEndpoints(list2, list);
            }
            catch (RoutingException routingException) {
                throw new SearchException((Throwable)routingException);
            }
        }
        if (object != null) {
            object.size();
        }
        ArrayList<org.petalslink.dsb.api.ServiceEndpoint> arrayList = new ArrayList<org.petalslink.dsb.api.ServiceEndpoint>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ServiceEndpoint serviceEndpoint = (ServiceEndpoint)iterator.next();
            arrayList.add(Adapter.createDSBServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint));
        }
        return arrayList;
    }

    public List<ServiceEndpoint> getEnabledEndpoints(kindSearch kindSearch2, QName qName, String string) throws RegistryException {
        this.log.call();
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        ServiceEndpoint[] serviceEndpointArray = null;
        serviceEndpointArray = kindSearch2 == kindSearch.SERVICE_SEARCH ? this.endpointRegistry.getInternalEndpointsForService(qName, LinkType.fromValue((String)string)) : this.endpointRegistry.getInternalEndpointsForInterface(qName, LinkType.fromValue((String)string));
        ServiceEndpoint[] serviceEndpointArray2 = serviceEndpointArray;
        int n = serviceEndpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceEndpoint serviceEndpoint = serviceEndpointArray2[n2];
            arrayList.add(serviceEndpoint);
            ++n2;
        }
        return arrayList;
    }

    private static List<Object> getAndAnalyseStrategy(String string) throws RoutingException {
        List<Object> list = string == null ? defaultStrategyParameters : EndpointSearchEngineImpl.analyseStrategy(string);
        return list;
    }

    private static final List<Object> analyseStrategy(String string) throws RoutingException {
        Float f;
        Float f2;
        Float f3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList2.add(stringTokenizer.nextToken().trim());
        }
        if (arrayList2.size() != 4) {
            throw new RoutingException("4 parameters are required for a routing strategy '" + string + "'");
        }
        String string2 = ((String)arrayList2.get(0)).toLowerCase();
        try {
            f3 = Float.valueOf((String)arrayList2.get(1));
            f2 = Float.valueOf((String)arrayList2.get(2));
            f = Float.valueOf((String)arrayList2.get(3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RoutingException("Impossible to convert a parameter to a float for the routing strategy '" + string + "'");
        }
        if (!string2.equals("highest") && !string2.equals("random")) {
            throw new RoutingException("the " + string2 + " routing strategy is unknown");
        }
        if (f3.floatValue() < 0.0f || f2.floatValue() < 0.0f || f.floatValue() < 0.0f) {
            throw new RoutingException("Negative parameter is forbidden in routing strategy");
        }
        if (f3.floatValue() == 0.0f && f2.floatValue() == 0.0f && f.floatValue() == 0.0f) {
            throw new RoutingException("Weightings '0,0,0' is forbidden");
        }
        arrayList.add(string2);
        arrayList.add(f3);
        arrayList.add(f2);
        arrayList.add(f);
        return arrayList;
    }

    public TopologyService getTopologyService() {
        return this.topologyService;
    }

    public void setTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setEndpointRegistry(EndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public List<org.petalslink.dsb.api.ServiceEndpoint> getAll() {
        ArrayList<org.petalslink.dsb.api.ServiceEndpoint> arrayList = new ArrayList<org.petalslink.dsb.api.ServiceEndpoint>();
        try {
            List list = this.endpointRegistry.getEndpoints();
            if (list != null) {
                for (ServiceEndpoint serviceEndpoint : list) {
                    arrayList.add(Adapter.createDSBServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint));
                }
            }
        }
        catch (RegistryException registryException) {
            registryException.printStackTrace();
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum kindSearch {
        SERVICE_SEARCH,
        INTERFACE_SEARCH;

    }
}

